"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisCallout = RootCauseAnalysisCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/components/rca/rca_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RootCauseAnalysisCallout({
  onClick,
  onCompleteInBackgroundClick,
  completeInBackground
}) {
  const checkboxId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasShadow: false,
    hasBorder: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center",
    className: (0, _css.css)`
              max-width: 512px;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.calloutTitle', {
    defaultMessage: 'AI-assisted root cause analysis'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.calloutText', {
    defaultMessage: `Start an automated investigation that will analyze
              log patterns, SLOs and alerts for entities and provide an evidence-
              based root cause analysis of issues in your system.`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: checkboxId,
    onChange: () => {
      onCompleteInBackgroundClick();
    },
    checked: completeInBackground,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: checkboxId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rootCauseAnalysisCallout.keepAnalysisRunningInFormLabelLabel', {
    defaultMessage: 'Keep analysis running in background'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantAppRootCauseAnalysisCalloutStartAnalysisButton",
    iconType: "sparkles",
    fill: true,
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.calloutText', {
    defaultMessage: 'Start analysis'
  })))))));
}