"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WrappedSetupModeRenderer = exports.SetupModeRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _global_state_context = require("../../application/contexts/global_state_context");
var _use_request_error_handler = require("../../application/hooks/use_request_error_handler");
var _setup_mode = require("../../lib/setup_mode");
var _flyout = require("../metricbeat_migration/flyout");
var _exit_button = require("../setup_mode/exit_button");
var _find_new_uuid = require("./lib/find_new_uuid");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/components/renderers/setup_mode.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class WrappedSetupModeRenderer extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "globalState", void 0);
    (0, _defineProperty2.default)(this, "state", {
      renderState: false,
      isFlyoutOpen: false,
      instance: null,
      newProduct: null,
      isSettingUpNew: false
    });
  }
  UNSAFE_componentWillMount() {
    this.globalState = this.context;
    const {
      kibana,
      onHttpError
    } = this.props;
    (0, _setup_mode.markSetupModeSupported)();
    (0, _setup_mode.initSetupModeState)(this.globalState, kibana.services.http, onHttpError, _oldData => {
      const newState = {
        renderState: true
      };
      const {
        productName
      } = this.props;
      if (!productName) {
        this.setState(newState);
        return;
      }
      const setupModeState = (0, _setup_mode.getSetupModeState)();
      if (!setupModeState.enabled || !setupModeState.data) {
        this.setState(newState);
        return;
      }
      const data = setupModeState.data[productName];
      const oldData = _oldData ? _oldData[productName] : null;
      if (data && oldData) {
        const newUuid = (0, _find_new_uuid.findNewUuid)(Object.keys(oldData.byUuid), Object.keys(data.byUuid));
        if (newUuid) {
          newState.newProduct = data.byUuid[newUuid];
        }
      }
      this.setState(newState);
    });
  }
  componentWillUnmount() {
    (0, _setup_mode.markSetupModeUnsupported)();
  }
  reset() {
    this.setState({
      renderState: false,
      isFlyoutOpen: false,
      instance: null,
      newProduct: null,
      isSettingUpNew: false
    });
  }
  getFlyout(data, meta) {
    const {
      productName
    } = this.props;
    const {
      isFlyoutOpen,
      instance,
      isSettingUpNew,
      newProduct
    } = this.state;
    if (!data || !isFlyoutOpen) {
      return null;
    }
    let product = null;
    if (newProduct) {
      product = newProduct;
    }
    // For new instance discovery flow, we pass in empty instance object
    else if (instance && Object.keys(instance).length) {
      product = data.byUuid[instance.uuid];
    }
    if (!product) {
      const uuids = Object.values(data.byUuid);
      if (uuids.length && !isSettingUpNew) {
        product = uuids[0];
      } else {
        product = {
          isNetNewUser: true
        };
      }
    }
    return /*#__PURE__*/_react.default.createElement(_flyout.Flyout, {
      onClose: () => this.reset(),
      productName: productName,
      product: product,
      meta: meta,
      instance: instance,
      updateProduct: _setup_mode.updateSetupModeData,
      isSettingUpNew: isSettingUpNew,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    });
  }
  getBottomBar(setupModeState) {
    if (!setupModeState.enabled || setupModeState.hideBottomBar) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      "data-test-subj": "monitoringSetupModeBottomBar",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.setupMode.description",
      defaultMessage: "You are in setup mode. The ({flagIcon}) icon indicates configuration options.",
      values: {
        flagIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "flag",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 144,
            columnNumber: 33
          }
        })
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 19
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_exit_button.SetupModeExitButton, {
      exitSetupMode: () => (0, _setup_mode.toggleSetupMode)(false),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 19
      }
    })))))));
  }
  async shortcutToFinishMigration() {
    await (0, _setup_mode.disableElasticsearchInternalCollection)();
    await (0, _setup_mode.updateSetupModeData)();
  }
  render() {
    const {
      render,
      productName
    } = this.props;
    const setupModeState = (0, _setup_mode.getSetupModeState)();
    let data = {
      byUuid: {}
    };
    if (setupModeState.data) {
      if (productName && setupModeState.data[productName]) {
        data = setupModeState.data[productName];
      } else if (setupModeState.data) {
        data = setupModeState.data;
      }
    }
    const meta = setupModeState.data ? setupModeState.data._meta : null;
    return render({
      setupMode: {
        data,
        meta,
        enabled: setupModeState.enabled,
        productName,
        updateSetupModeData: _setup_mode.updateSetupModeData,
        shortcutToFinishMigration: () => this.shortcutToFinishMigration(),
        openFlyout: (instance, isSettingUpNew) => this.setState({
          isFlyoutOpen: true,
          instance,
          isSettingUpNew
        }),
        closeFlyout: () => this.setState({
          isFlyoutOpen: false
        })
      },
      flyoutComponent: this.getFlyout(data, meta),
      bottomBarComponent: this.getBottomBar(setupModeState)
    });
  }
}
exports.WrappedSetupModeRenderer = WrappedSetupModeRenderer;
function withErrorHandler(Component) {
  return function WrappedComponent(props) {
    const handleRequestError = (0, _use_request_error_handler.useRequestErrorHandler)();
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      onHttpError: handleRequestError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 12
      }
    }));
  };
}
WrappedSetupModeRenderer.contextType = _global_state_context.GlobalStateContext;
const SetupModeRenderer = exports.SetupModeRenderer = (0, _public.withKibana)(withErrorHandler(WrappedSetupModeRenderer));