"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchMLJobs = void 0;
var _lodash = require("lodash");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _formatting = require("../../../../common/formatting");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _table = require("../../table");
var _status_icon = require("../ml_job_listing/status_icon");
var _cluster_status = require("../cluster_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/ml_jobs/ml_jobs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ElasticsearchMLJobs = ({
  clusterStatus,
  jobs,
  sorting,
  pagination,
  onTableChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
    stats: clusterStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    "data-test-subj": "mlJobsTable",
    rows: jobs,
    columns: columns,
    sorting: {
      ...sorting,
      sort: {
        ...sorting.sort,
        field: 'job_id'
      }
    },
    pagination: pagination,
    message: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.noJobsDescription', {
      defaultMessage: 'There are no machine learning jobs that match your query. Try changing the time range selection.'
    }),
    search: {
      box: {
        incremental: true,
        placeholder: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.filterJobsPlaceholder', {
          defaultMessage: 'Filter Jobs…'
        })
      }
    },
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['job_id']
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }))));
};
exports.ElasticsearchMLJobs = ElasticsearchMLJobs;
const columns = [{
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.jobIdTitle', {
    defaultMessage: 'Job ID'
  }),
  field: 'job_id',
  sortable: true
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.stateTitle', {
    defaultMessage: 'State'
  }),
  field: 'state',
  sortable: true,
  render: state => /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_status_icon.MachineLearningJobStatusIcon, {
    status: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), "\xA0", (0, _lodash.capitalize)(state))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.processedRecordsTitle', {
    defaultMessage: 'Processed Records'
  }),
  field: 'data_counts.processed_record_count',
  sortable: true,
  render: value => /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 33
    }
  }, (0, _numeral.default)(value).format(_formatting.LARGE_ABBREVIATED))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.modelSizeTitle', {
    defaultMessage: 'Model Size'
  }),
  field: 'model_size_stats.model_bytes',
  sortable: true,
  render: value => /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 33
    }
  }, (0, _numeral.default)(value).format(_formatting.LARGE_BYTES))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.forecastsTitle', {
    defaultMessage: 'Forecasts'
  }),
  field: 'forecasts_stats.total',
  sortable: true,
  render: value => /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 33
    }
  }, (0, _numeral.default)(value).format(_formatting.LARGE_ABBREVIATED))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.nodeTitle', {
    defaultMessage: 'Node'
  }),
  field: 'node.name',
  sortable: true,
  render: (name, job) => {
    if (job.node) {
      if ('id' in job.node) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/nodes/${job.node.id}`),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 13
          }
        }, name);
      } else return /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 23
        }
      }, name);
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.mlJobListing.noDataLabel",
      defaultMessage: "N/A",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    });
  }
}];