"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertPanelsByCategory = getAlertPanelsByCategory;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _panel = require("../panel");
var _constants = require("../../../common/constants");
var _formatting = require("../../../common/formatting");
var _sort_by_newest_alert = require("./sort_by_newest_alert");
var _legacy_shims = require("../../legacy_shims");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/lib/get_alert_panels_by_category.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getAlertPanelsByCategory(panelTitle, inSetupMode, alerts, stateFilter) {
  // return items organized by categories in RULE_PANEL_MENU
  // only show rules in setup mode
  const menu = inSetupMode ? _constants.RULE_PANEL_MENU.reduce((acc, category) => {
    // check if we have any rules with that match this category
    const alertsInCategory = category.rules.filter(rule => alerts.find(({
      sanitizedRule
    }) => sanitizedRule.alertTypeId === rule.ruleName));
    // return all the categories that have rules and the rules
    if (alertsInCategory.length > 0) {
      // add the category item to the menu
      acc.push({
        ...category,
        // add the corresponding rules that belong to this category
        alerts: alertsInCategory.map(({
          ruleName
        }) => {
          return alerts.filter(({
            sanitizedRule
          }) => sanitizedRule.alertTypeId === ruleName).map(alert => {
            return {
              alert: alert.sanitizedRule,
              states: [],
              ruleName
            };
          });
        }).flat(),
        alertCount: 0
      });
    }
    return acc;
  }, []) : _constants.RULE_PANEL_MENU.reduce((acc, category) => {
    // return items organized by categories in RULE_PANEL_MENU, then rule name, then the actual alerts
    const firingAlertsInCategory = [];
    let categoryFiringAlertCount = 0;
    for (const {
      ruleName
    } of category.rules) {
      const foundAlerts = alerts.filter(({
        sanitizedRule,
        states
      }) => ruleName === sanitizedRule.alertTypeId && states.length > 0);
      if (foundAlerts.length > 0) {
        foundAlerts.forEach(foundAlert => {
          // add corresponding alerts to each rule
          const states = foundAlert.states.filter(({
            state
          }) => stateFilter(state));
          if (states.length > 0) {
            firingAlertsInCategory.push({
              alert: foundAlert.sanitizedRule,
              states,
              ruleName
            });
            categoryFiringAlertCount += states.length;
          }
        });
      }
    }
    if (firingAlertsInCategory.length > 0) {
      acc.push({
        ...category,
        alertCount: categoryFiringAlertCount,
        alerts: firingAlertsInCategory
      });
    }
    return acc;
  }, []);
  for (const item of menu) {
    for (const alert of item.alerts) {
      alert.states.sort(_sort_by_newest_alert.sortByNewestAlert);
    }
  }
  // if in setup mode add the count of alerts to the category name
  const panels = [{
    id: 0,
    title: panelTitle,
    items: [...menu.map((category, index) => {
      const name = inSetupMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      }, category.label) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 15
        }
      }, category.label, " (", category.alertCount, ")"));
      return {
        name,
        panel: index + 1
      };
    })]
  }];
  if (inSetupMode) {
    // create the nested UI menu: category name -> rule name -> edit rule
    let secondaryPanelIndex = menu.length;
    let tertiaryPanelIndex = menu.length;
    let nodeIndex = 0;
    for (const category of menu) {
      panels.push({
        id: nodeIndex + 1,
        title: `${category.label}`,
        items: category.alerts.map(alert => {
          return {
            name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 147,
                columnNumber: 21
              }
            }, alert.alert.name),
            panel: ++secondaryPanelIndex
          };
        }).flat()
      });
      nodeIndex++;
    }
    for (const category of menu) {
      for (const {
        alert
      } of category.alerts) {
        panels.push({
          id: ++tertiaryPanelIndex,
          title: `${alert.name}`,
          width: 400,
          content: /*#__PURE__*/_react.default.createElement(_panel.AlertPanel, {
            alert: alert,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 161,
              columnNumber: 20
            }
          })
        });
      }
    }
  } else {
    // create the nested UI menu: category name (n) -> rule name (n) -> list of firing alerts
    let primaryPanelIndex = menu.length;
    let nodeIndex = 0;
    for (const category of menu) {
      panels.push({
        id: nodeIndex + 1,
        title: `${category.label}`,
        items: category.alerts.map(({
          alert,
          ruleName,
          states
        }) => {
          const filteredStates = states.filter(({
            state
          }) => stateFilter(state));
          const name = inSetupMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 176,
              columnNumber: 13
            }
          }, alert.name) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 178,
              columnNumber: 13
            }
          }, alert.name, " (", filteredStates.length, ")");
          return {
            name,
            panel: ++primaryPanelIndex
          };
        })
      });
      nodeIndex++;
    }
    let secondaryPanelIndex = menu.length;
    let tertiaryPanelIndex = menu.reduce((count, category) => {
      count += category.alerts.length;
      return count;
    }, menu.length);
    for (const category of menu) {
      for (const {
        alert,
        states
      } of category.alerts) {
        const items = [];
        for (const alertState of states.filter(({
          state
        }) => stateFilter(state))) {
          const {
            nodeName,
            itemLabel
          } = alertState.state;
          items.push({
            name: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 203,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
              position: "top",
              content: (0, _formatting.getCalendar)(alertState.state.ui.triggeredMS, _legacy_shims.Legacy.shims.uiSettings.get('dateFormat:tz')),
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 204,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: "s",
              tabIndex: 0,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 211,
                columnNumber: 19
              }
            }, (0, _formatting.getDateFromNow)(alertState.state.ui.triggeredMS, _legacy_shims.Legacy.shims.uiSettings.get('dateFormat:tz')))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: "s",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 218,
                columnNumber: 17
              }
            }, nodeName || itemLabel)),
            panel: ++tertiaryPanelIndex
          });
          items.push({
            isSeparator: true
          });
        }
        panels.push({
          id: ++secondaryPanelIndex,
          title: `${alert.name}`,
          items
        });
      }
    }
    let tertiaryPanelIndex2 = menu.reduce((count, category) => {
      count += category.alerts.length;
      return count;
    }, menu.length);
    for (const category of menu) {
      for (const {
        alert,
        states
      } of category.alerts) {
        for (const state of states.filter(({
          state: _state
        }) => stateFilter(_state))) {
          panels.push({
            id: ++tertiaryPanelIndex2,
            title: `${alert.name}`,
            width: 400,
            content: /*#__PURE__*/_react.default.createElement(_panel.AlertPanel, {
              alert: alert,
              alertState: state,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 246,
                columnNumber: 22
              }
            })
          });
        }
      }
    }
  }
  return panels;
}