"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XJsonLang = void 0;
var _worker_proxy = require("../../ace_migration/worker_proxy");
var _setup_worker = require("../../ace_migration/setup_worker");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// This file contains a lot of single setup logic for registering a language globally

const XJsonLang = exports.XJsonLang = {
  ID: _constants.ID,
  onLanguage() {
    const OWNER = 'XJSON_GRAMMAR_CHECKER';
    const wps = new _worker_proxy.WorkerProxyService();
    (0, _setup_worker.setupWorker)(_constants.ID, OWNER, wps);
  }
};