"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPICAL_TO_ACTUAL = exports.TYPICAL_LABEL = exports.AnomalySourceTooltipProperty = exports.AnomalySourceField = exports.ANOMALY_SOURCE_FIELDS = exports.ACTUAL_LABEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/maps-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/maps/anomaly_source_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line max-classes-per-file
const ACTUAL_LABEL = exports.ACTUAL_LABEL = _i18n.i18n.translate('xpack.ml.maps.anomalyLayerActualLabel', {
  defaultMessage: 'Actual'
});
const TYPICAL_LABEL = exports.TYPICAL_LABEL = _i18n.i18n.translate('xpack.ml.maps.anomalyLayerTypicalLabel', {
  defaultMessage: 'Typical'
});
const TYPICAL_TO_ACTUAL = exports.TYPICAL_TO_ACTUAL = _i18n.i18n.translate('xpack.ml.maps.anomalyLayerTypicalToActualLabel', {
  defaultMessage: 'Typical to actual'
});
const INFLUENCER_LIMIT = 3;
const ANOMALY_SOURCE_FIELDS = exports.ANOMALY_SOURCE_FIELDS = {
  record_score: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerRecordScoreLabel', {
      defaultMessage: 'Record score'
    }),
    type: 'number'
  },
  timestamp: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerTimeStampLabel', {
      defaultMessage: 'Time'
    }),
    type: 'string'
  },
  fieldName: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerFieldNameLabel', {
      defaultMessage: 'Field name'
    }),
    type: 'string'
  },
  functionDescription: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerFunctionDescriptionLabel', {
      defaultMessage: 'Function'
    }),
    type: 'string'
  },
  actual: {
    label: ACTUAL_LABEL,
    type: 'string'
  },
  typical: {
    label: TYPICAL_LABEL,
    type: 'string'
  },
  partition_field_name: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerPartitionFieldNameLabel', {
      defaultMessage: 'Partition field name'
    }),
    type: 'string'
  },
  partition_field_value: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerPartitionFieldValueLabel', {
      defaultMessage: 'Partition field value'
    }),
    type: 'string'
  },
  by_field_name: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerByFieldNameLabel', {
      defaultMessage: 'By field name'
    }),
    type: 'string'
  },
  by_field_value: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerByFieldValueLabel', {
      defaultMessage: 'By field value'
    }),
    type: 'string'
  },
  over_field_name: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerOverFieldNameLabel', {
      defaultMessage: 'Over field name'
    }),
    type: 'string'
  },
  over_field_value: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerOverFieldValueLabel', {
      defaultMessage: 'Over field value'
    }),
    type: 'string'
  },
  influencers: {
    label: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerInfluencersLabel', {
      defaultMessage: 'Influencers'
    }),
    type: 'string'
  }
};
const ROUND_POWER = Math.pow(10, _common.DECIMAL_DEGREES_PRECISION);
function roundCoordinate(coordinate) {
  return Math.round(Number(coordinate) * ROUND_POWER) / ROUND_POWER;
}
class AnomalySourceTooltipProperty {
  constructor(_field, _value) {
    this._field = _field;
    this._value = _value;
  }
  async getESFilters() {
    return [];
  }
  getHtmlDisplayValue() {
    if (this._field === 'influencers') {
      try {
        const influencers = JSON.parse(this._value);
        return /*#__PURE__*/_react.default.createElement("ul", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 11
          }
        }, influencers.map(({
          influencer_field_name: name,
          influencer_field_values: values
        }) => {
          return /*#__PURE__*/_react.default.createElement("li", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 136,
              columnNumber: 22
            }
          }, `${name}: ${values.slice(0, INFLUENCER_LIMIT).join(', ')}`);
        }));
      } catch (error) {
        // ignore error and display unformated value
      }
    } else if (this._field === 'actual' || this._field === 'typical') {
      try {
        const point = JSON.parse(this._value);
        return `[${roundCoordinate(point[0])}, ${roundCoordinate(point[1])}]`;
      } catch (error) {
        // ignore error and display unformated value
      }
    }
    return this._value.toString();
  }
  getPropertyKey() {
    return this._field;
  }
  getPropertyName() {
    return ANOMALY_SOURCE_FIELDS[this._field] && ANOMALY_SOURCE_FIELDS[this._field].label ? ANOMALY_SOURCE_FIELDS[this._field].label : this._field;
  }
  getRawValue() {
    return this._value.toString();
  }
  isFilterable() {
    return false;
  }
}

// this needs to be generic so it works for all fields in anomaly record result
exports.AnomalySourceTooltipProperty = AnomalySourceTooltipProperty;
class AnomalySourceField {
  constructor({
    source,
    field
  }) {
    (0, _defineProperty2.default)(this, "_source", void 0);
    (0, _defineProperty2.default)(this, "_field", void 0);
    this._source = source;
    this._field = field;
  }
  async createTooltipProperty(value) {
    return new AnomalySourceTooltipProperty(this._field, (0, _lodash.escape)(Array.isArray(value) ? value.join() : value ? value : ''));
  }
  async getDataType() {
    return ANOMALY_SOURCE_FIELDS[this._field].type;
  }
  async getLabel() {
    return ANOMALY_SOURCE_FIELDS[this._field].label;
  }
  getName() {
    return this._field;
  }
  getMbFieldName() {
    return this.getName();
  }
  getOrigin() {
    return _common.FIELD_ORIGIN.SOURCE;
  }
  getRootName() {
    return this.getName();
  }
  getSource() {
    return this._source;
  }
  isEqual(field) {
    return this.getName() === field.getName();
  }
  isValid() {
    return true;
  }
  supportsFieldMetaFromLocalData() {
    return true;
  }
  supportsFieldMetaFromEs() {
    return false;
  }
  canValueBeFormatted() {
    return false;
  }
  async getExtendedStatsFieldMetaRequest() {
    return null;
  }
  async getPercentilesFieldMetaRequest(percentiles) {
    return null;
  }
  async getCategoricalFieldMetaRequest(size) {
    return null;
  }
  pluckRangeFromTileMetaFeature(metaFeature) {
    return null;
  }
  isCount() {
    return false;
  }
}
exports.AnomalySourceField = AnomalySourceField;