"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMlManagementHref = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides a URL to ML management pages
 */
const useMlManagementHref = (ml, params, appId = 'anomaly_detection') => {
  const [mlManagementUrl, setMlManagementUrl] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(function setUpMlUrl() {
    const getUrl = async () => {
      if (ml && ml.managementLocator) {
        var _ml$managementLocator;
        const result = await ((_ml$managementLocator = ml.managementLocator) === null || _ml$managementLocator === void 0 ? void 0 : _ml$managementLocator.getUrl(params, appId));
        if (result.url) {
          setMlManagementUrl(result.url);
        }
      }
    };
    getUrl();
  }, [appId, params, ml]);
  return mlManagementUrl;
};
exports.useMlManagementHref = useMlManagementHref;