"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompatibleLayer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_from_lens = require("../../../../../application/jobs/new_job/job_from_lens");
var _new_job = require("../../../../../../common/constants/new_job");
var _context = require("../../../common/context");
var _job_details = require("../../../common/job_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/job_creation/lens/lens_vis_layer_selection_flyout/layer/compatible_layer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// useCallback
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CompatibleLayer = ({
  layer,
  layerIndex,
  embeddable
}) => {
  var _embeddable$timeRange;
  const {
    services: {
      data,
      share,
      uiSettings,
      lens,
      mlServices: {
        mlApi
      }
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const quickJobCreator = (0, _react.useMemo)(() => new _job_from_lens.QuickLensJobCreator(lens, data.dataViews, uiSettings, data.query.timefilter.timefilter, share, mlApi),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data, uiSettings]);
  function createADJobInWizard() {
    (0, _job_from_lens.redirectToADJobWizards)(embeddable, layerIndex, share, lens);
  }
  async function createADJob({
    jobId,
    bucketSpan,
    startJob,
    runInRealTime
  }) {
    const result = await quickJobCreator.createAndSaveJob(jobId, bucketSpan, embeddable, startJob, runInRealTime, layerIndex);
    return result;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    createADJob: createADJob,
    createADJobInWizard: createADJobInWizard,
    timeRange: (_embeddable$timeRange = embeddable.timeRange$) === null || _embeddable$timeRange === void 0 ? void 0 : _embeddable$timeRange.value,
    layer: layer,
    layerIndex: layerIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "mlLensLayerCompatible",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, layer.jobType === _new_job.JOB_TYPE.MULTI_METRIC ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.createJobCalloutTitle.multiMetric",
    defaultMessage: "This layer can be used to create a multi-metric job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.createJobCalloutTitle.singleMetric",
    defaultMessage: "This layer can be used to create a single metric job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 17
    }
  }))))));
};
exports.CompatibleLayer = CompatibleLayer;