"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processFilters = processFilters;
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processFilters(optionalFilters, optionalQuery, controlledBy) {
  const allFilters = optionalFilters !== null && optionalFilters !== void 0 ? optionalFilters : [];
  // Filter out filters controlled by the specified controlledBy value
  const filters = controlledBy !== undefined ? allFilters.filter(filter => filter.meta.controlledBy !== controlledBy) : allFilters;

  // We do not support esql yet
  const query = (0, _esQuery.isOfAggregateQueryType)(optionalQuery) ? (0, _public.getDefaultQuery)() : optionalQuery;
  return (0, _esQuery.buildEsQuery)(undefined, query !== null && query !== void 0 ? query : [], filters, {});
}