"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocTitle = void 0;
var _react = require("react");
var _app = require("../../../common/constants/app");
var _kibana = require("../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Handles document title automatically based on the active route.
 * Returns a callback for manual title updates.
 */
const useDocTitle = activeRoute => {
  const activeRouteTitle = activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.title;
  const {
    services: {
      chrome: {
        docTitle
      }
    }
  } = (0, _kibana.useMlKibana)();
  const updateDocTitle = (0, _react.useCallback)(title => {
    docTitle.change([title, _app.ML_APP_NAME]);
  }, [docTitle]);
  (0, _react.useEffect)(() => {
    if (activeRouteTitle) {
      updateDocTitle(activeRouteTitle);
    }
  }, [updateDocTitle, activeRouteTitle]);
  return updateDocTitle;
};
exports.useDocTitle = useDocTitle;