"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settingsRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _breadcrumbs = require("../../breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/settings/settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Settings = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../settings')))).Settings
}));
const settingsRouteFactory = navigateToApp => ({
  id: 'settings',
  path: '/',
  title: _i18n.i18n.translate('xpack.ml.settings.docTitle', {
    defaultMessage: 'Anomaly Detection Settings'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 17
    }
  }),
  breadcrumbs: [(0, _breadcrumbs.getStackManagementBreadcrumb)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB', navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.settingsLabel', {
      defaultMessage: 'Anomaly Detection Settings'
    })
  }]
});
exports.settingsRouteFactory = settingsRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    getMlNodeCount: _check_ml_nodes.getMlNodeCount
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Settings, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
};