"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelPipelines = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../contexts/kibana");
var _expanded_row = require("./expanded_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/pipelines/pipelines.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ModelPipelines = ({
  pipelines,
  ingestStats
}) => {
  var _ref;
  const {
    services: {
      share
    }
  } = (0, _kibana.useMlKibana)();
  const pipelineNames = Object.keys((_ref = pipelines !== null && pipelines !== void 0 ? pipelines : ingestStats === null || ingestStats === void 0 ? void 0 : ingestStats.pipelines) !== null && _ref !== void 0 ? _ref : {});
  if (!pipelineNames.length) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pipelineNames.map((pipelineName, i) => {
    var _pipelines$pipelineNa, _pipelines$pipelineNa2;
    // Expand first 3 pipelines by default
    const initialIsOpen = i <= 2;
    const pipelineDefinition = pipelines === null || pipelines === void 0 ? void 0 : pipelines[pipelineName];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: pipelineName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: pipelineName,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 19
        }
      }, pipelineName)),
      extraAction: pipelineDefinition ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": `mlTrainedModelPipelineEditButton_${pipelineName}`,
        onClick: () => {
          const locator = share.url.locators.get('INGEST_PIPELINES_APP_LOCATOR');
          if (!locator) return;
          locator.navigate({
            page: 'pipeline_edit',
            pipelineId: pipelineName,
            absolute: true
          });
        },
        iconType: 'documentEdit',
        iconSide: "left",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.editPipelineLabel",
        defaultMessage: "Edit",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 21
        }
      })) : undefined,
      paddingSize: "l",
      initialIsOpen: initialIsOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 2,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 15
      }
    }, (_pipelines$pipelineNa = ingestStats.pipelines[pipelineName]) !== null && _pipelines$pipelineNa !== void 0 && _pipelines$pipelineNa.processors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `mlTrainedModelPipelineIngestStats_${pipelineName}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xxs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.expandedRow.ingestStatsTitle",
      defaultMessage: "Ingest stats",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 27
      }
    }))), /*#__PURE__*/_react.default.createElement(_expanded_row.ProcessorsStats, {
      stats: (_pipelines$pipelineNa2 = ingestStats.pipelines[pipelineName]) === null || _pipelines$pipelineNa2 === void 0 ? void 0 : _pipelines$pipelineNa2.processors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 23
      }
    }))) : null, pipelineDefinition ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `mlTrainedModelPipelineDefinition_${pipelineName}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xxs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.expandedRow.processorsTitle",
      defaultMessage: "Definition",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 27
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "m",
      paddingSize: "m",
      overflowHeight: 300,
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 23
      }
    }, JSON.stringify(pipelineDefinition, null, 2)))) : null)));
  }));
};
exports.ModelPipelines = ModelPipelines;