"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostSaveOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _states = require("../../../../../../../../../common/constants/states");
var _ml_alerting_flyout = require("../../../../../../../../alerting/ml_alerting_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/summary_step/components/post_save_options/post_save_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PostSaveOptions = ({
  jobRunner
}) => {
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [datafeedState, setDatafeedState] = (0, _react.useState)(_states.DATAFEED_STATE.STOPPED);
  const [alertFlyoutVisible, setAlertFlyoutVisible] = (0, _react.useState)(false);
  async function startJobInRealTime() {
    const {
      toasts
    } = notifications;
    setDatafeedState(_states.DATAFEED_STATE.STARTING);
    if (jobRunner !== null) {
      try {
        const started = await jobRunner.startDatafeedInRealTime(true);
        setDatafeedState(started === true ? _states.DATAFEED_STATE.STARTED : _states.DATAFEED_STATE.STOPPED);
        toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.postSaveOptions.startJobInRealTimeSuccess', {
            defaultMessage: `Job {jobId} started`,
            values: {
              jobId: jobCreator.jobId
            }
          })
        });
      } catch (error) {
        setDatafeedState(_states.DATAFEED_STATE.STOPPED);
        toasts.addDanger({
          title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.postSaveOptions.startJobInRealTimeError', {
            defaultMessage: `Error starting job`
          }),
          text: (0, _mlErrorUtils.extractErrorMessage)(error)
        });
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: datafeedState === _states.DATAFEED_STATE.STARTING || datafeedState === _states.DATAFEED_STATE.STARTED,
    onClick: startJobInRealTime,
    "data-test-subj": "mlJobWizardButtonRunInRealTime",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.postSaveOptions.startJobInRealTime",
    defaultMessage: "Start job running in real time",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: datafeedState === _states.DATAFEED_STATE.STOPPED || datafeedState === _states.DATAFEED_STATE.STARTING,
    onClick: setAlertFlyoutVisible.bind(null, true),
    "data-test-subj": "mlJobWizardButtonCreateAlert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.postSaveOptions.createAlert",
    defaultMessage: "Create alert rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }))), datafeedState === _states.DATAFEED_STATE.STARTED && alertFlyoutVisible && /*#__PURE__*/_react.default.createElement(_ml_alerting_flyout.MlAnomalyAlertFlyout, {
    jobIds: [jobCreator.jobId],
    onCloseFlyout: setAlertFlyoutVisible.bind(null, false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }));
};
exports.PostSaveOptions = PostSaveOptions;