"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExamplesValidCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlCategoryValidator = require("@kbn/ml-category-validator");
var _edit_categorization_analyzer_flyout = require("../../../common/edit_categorization_analyzer_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_view/examples_valid_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const allChecksButtonContent = _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.allChecksButton', {
  defaultMessage: 'View all checks performed'
});
const ExamplesValidCallout = ({
  overallValidStatus,
  validationChecks,
  categorizationAnalyzer
}) => {
  const analyzerUsed = /*#__PURE__*/_react.default.createElement(AnalyzerUsed, {
    categorizationAnalyzer: categorizationAnalyzer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 24
    }
  });
  let color = 'success';
  let title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldCalloutTitle.valid', {
    defaultMessage: 'Selected category field is valid'
  });
  if (overallValidStatus === _mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID) {
    color = 'danger';
    title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldCalloutTitle.invalid', {
      defaultMessage: 'Selected category field is invalid'
    });
  } else if (overallValidStatus === _mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.PARTIALLY_VALID) {
    color = 'warning';
    title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldCalloutTitle.possiblyInvalid', {
      defaultMessage: 'Selected category field is possibly invalid'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: color,
    title: title,
    "data-test-subj": `mlJobWizardCategorizationExamplesCallout ${overallValidStatus}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, validationChecks.map((v, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, v.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), analyzerUsed, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "all-checks",
    buttonContent: allChecksButtonContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AllValidationChecks, {
    validationChecks: validationChecks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })));
};
exports.ExamplesValidCallout = ExamplesValidCallout;
const AnalyzerUsed = ({
  categorizationAnalyzer
}) => {
  let analyzer = null;
  if ((categorizationAnalyzer === null || categorizationAnalyzer === void 0 ? void 0 : categorizationAnalyzer.tokenizer) !== undefined && typeof categorizationAnalyzer.tokenizer === 'string') {
    analyzer = categorizationAnalyzer.tokenizer;
  } else if ((categorizationAnalyzer === null || categorizationAnalyzer === void 0 ? void 0 : categorizationAnalyzer.analyzer) !== undefined) {
    analyzer = categorizationAnalyzer.analyzer;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, analyzer !== null ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldAnalyzer",
    defaultMessage: "Analyzer used: {analyzer}",
    values: {
      analyzer
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_categorization_analyzer_flyout.EditCategorizationAnalyzerFlyout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  })));
};
const AllValidationChecks = ({
  validationChecks
}) => {
  const list = Object.keys(_mlCategoryValidator.VALIDATION_CHECK_DESCRIPTION).map((k, i) => {
    const failedCheck = validationChecks.find(vc => vc.id === i);
    if (failedCheck !== undefined && (failedCheck === null || failedCheck === void 0 ? void 0 : failedCheck.valid) !== _mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.VALID) {
      return {
        iconType: 'cross',
        label: failedCheck.message,
        size: 's'
      };
    }
    return {
      iconType: 'check',
      label: _mlCategoryValidator.VALIDATION_CHECK_DESCRIPTION[i],
      size: 's'
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: list,
    maxWidth: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 10
    }
  });
};