"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobIdInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/job_id/job_id_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobIdInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [jobId, setJobId] = (0, _react.useState)(jobCreator.jobId);
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'jobIdInput'
  });
  const validation = (0, _react.useMemo)(() => {
    var _jobValidator$latestV, _jobValidator$jobId$m, _jobValidator$latestV2;
    const isEmptyId = jobId === '';
    const valid = isEmptyId === true || jobValidator.jobId.valid === true && ((_jobValidator$latestV = jobValidator.latestValidationResult.jobIdExists) === null || _jobValidator$latestV === void 0 ? void 0 : _jobValidator$latestV.valid) === true;
    const message = (_jobValidator$jobId$m = jobValidator.jobId.message) !== null && _jobValidator$jobId$m !== void 0 ? _jobValidator$jobId$m : (_jobValidator$latestV2 = jobValidator.latestValidationResult.jobIdExists) === null || _jobValidator$latestV2 === void 0 ? void 0 : _jobValidator$latestV2.message;
    return {
      valid,
      message
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  (0, _react.useEffect)(() => {
    jobCreator.jobId = jobId;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: jobId,
    onChange: e => setJobId(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputJobId",
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.JobIdInput = JobIdInput;