"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScrollSizeInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ml_server_info = require("../../../../../../../services/ml_server_info");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/datafeed_step/components/scroll_size/scroll_size_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ScrollSizeInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.scrollSize);
  const [scrollSizeString, setScrollSize] = (0, _react.useState)(jobCreator.scrollSize === null ? '' : `${jobCreator.scrollSize}`);
  const {
    datafeeds
  } = (0, _ml_server_info.getNewJobDefaults)();
  const scrollSizeDefault = datafeeds.scroll_size !== undefined ? `${datafeeds.scroll_size}` : '';
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'scrollSizeInput'
  });
  (0, _react.useEffect)(() => {
    jobCreator.scrollSize = scrollSizeString === '' ? null : +scrollSizeString;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [scrollSizeString]);
  (0, _react.useEffect)(() => {
    setScrollSize(jobCreator.scrollSize === null ? '' : `${jobCreator.scrollSize}`);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdate]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.scrollSize);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    min: 0,
    placeholder: scrollSizeDefault,
    value: scrollSizeString === '' ? scrollSizeString : +scrollSizeString,
    onChange: e => setScrollSize(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputScrollSize",
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
};
exports.ScrollSizeInput = ScrollSizeInput;