"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynchronizeSavedObjectsButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _job_spaces_sync = require("../../../../components/job_spaces_sync");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/top_level_actions/synchronize_saved_objects_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SynchronizeSavedObjectsButton = ({
  refreshJobs
}) => {
  const [showSyncFlyout, setShowSyncFlyout] = (0, _react.useState)(false);
  function onCloseSyncFlyout() {
    if (typeof refreshJobs === 'function') {
      refreshJobs();
    }
    setShowSyncFlyout(false);
  }
  const [canCreateJob, canCreateDataFrameAnalytics, canCreateTrainedModels] = (0, _check_capabilities.usePermissionCheck)(['canCreateJob', 'canCreateDataFrameAnalytics', 'canCreateTrainedModels']);
  const canSync = (0, _react.useMemo)(() => canCreateJob || canCreateDataFrameAnalytics || canCreateTrainedModels, [canCreateDataFrameAnalytics, canCreateJob, canCreateTrainedModels]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: !canSync,
    size: "m",
    flush: "left",
    iconType: "inputOutput",
    onClick: () => setShowSyncFlyout(true),
    "data-test-subj": "mlStackMgmtSyncButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.jobsList.syncFlyoutButton",
    defaultMessage: "Synchronize saved objects",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })), showSyncFlyout && /*#__PURE__*/_react.default.createElement(_job_spaces_sync.JobSpacesSyncFlyout, {
    onClose: onCloseSyncFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 26
    }
  }));
};
exports.SynchronizeSavedObjectsButton = SynchronizeSavedObjectsButton;