"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_group = require("../../../job_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/multi_job_actions/group_selector/group_list/group_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Check({
  group,
  selectedGroups
}) {
  if (selectedGroups[group.id] !== undefined) {
    if (selectedGroups[group.id].partial) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "check selected",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 19,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 20,
          columnNumber: 11
        }
      }, "\u2014"));
    } else {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "check selected",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 26,
          columnNumber: 11
        }
      }));
    }
  } else {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "check",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 12
      }
    });
  }
}
class GroupList extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "selectGroup", group => {
      this.props.selectGroup(group);
    });
    (0, _defineProperty2.default)(this, "moveUp", (event, index) => {
      event.preventDefault();
      if (index < 0) {
        return;
      } else if (index > 0) {
        this.selectItems[index - 1].focus();
      }
    });
    (0, _defineProperty2.default)(this, "moveDown", (event, index) => {
      event.preventDefault();
      if (index < this.selectItems.length - 1) {
        this.selectItems[index + 1].focus();
      }
    });
    (0, _defineProperty2.default)(this, "handleKeyDown", (event, group, index) => {
      switch (event.key) {
        case _eui.keys.ENTER:
          this.selectGroup(group);
          break;
        case _eui.keys.SPACE:
          this.selectGroup(group);
          break;
        case _eui.keys.ARROW_DOWN:
          this.moveDown(event, index);
          break;
        case _eui.keys.ARROW_UP:
          this.moveUp(event, index);
          break;
      }
    });
    (0, _defineProperty2.default)(this, "setRef", (ref, index) => {
      this.selectItems[index] = ref;
    });
    this.state = {
      groups: []
    };
    // keep track of each of the group item refs
    this.selectItems = [];
  }
  render() {
    const {
      selectedGroups,
      groups
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, groups.map((g, index) => /*#__PURE__*/_react.default.createElement("div", {
      tabIndex: '0',
      onKeyDown: event => this.handleKeyDown(event, g, index),
      key: g.id,
      className: "group-item",
      onClick: () => this.selectGroup(g),
      ref: ref => this.setRef(ref, index),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_job_group.JobGroup, {
      name: g.id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(Check, {
      group: g,
      selectedGroups: selectedGroups,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 17
      }
    }))))));
  }
}
exports.GroupList = GroupList;
GroupList.propTypes = {
  selectedGroups: _propTypes.default.object.isRequired,
  groups: _propTypes.default.array.isRequired,
  selectGroup: _propTypes.default.func.isRequired
};