"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startActionNameText = exports.StartActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_start/start_action_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const startActionNameText = exports.startActionNameText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.startActionNameText', {
  defaultMessage: 'Start'
});
const StartActionName = ({
  canStartStopDataFrameAnalytics,
  isDisabled,
  item
}) => {
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: !canStartStopDataFrameAnalytics ? (0, _check_capabilities.createPermissionFailureMessage)('canStartStopDataFrameAnalytics') : _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.completeBatchAnalyticsToolTip', {
        defaultMessage: '{analyticsId} is a completed analytics job and cannot be restarted.',
        values: {
          analyticsId: item.config.id
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, startActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startActionNameText);
};
exports.StartActionName = StartActionName;