"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSelector = JobSelector;
exports.getInitialGroupsMap = getInitialGroupsMap;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _locator = require("../../../locator");
var _id_badges = require("./id_badges");
var _job_selector_flyout = require("./job_selector_flyout");
var _feedback_button = require("../feedback_button");
var _job_details_flyout = require("../../jobs/components/job_details_flyout");
var _job_details_context_manager = require("../../jobs/components/job_details_flyout/job_details_context_manager");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _use_create_url = require("../../contexts/kibana/use_create_url");
var _use_job_selection_flyout = require("../../contexts/ml/use_job_selection_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_selector/job_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function mergeSelection(jobIds, groupObjs, singleSelection) {
  if (singleSelection) {
    return jobIds;
  }
  const selectedIds = [];
  const alreadySelected = [];
  groupObjs.forEach(group => {
    selectedIds.push(group.groupId);
    alreadySelected.push(...group.jobIds);
  });
  jobIds.forEach(jobId => {
    // Add jobId if not already included in group selection
    if (alreadySelected.includes(jobId) === false) {
      selectedIds.push(jobId);
    }
  });
  return selectedIds;
}
function getInitialGroupsMap(selectedGroups) {
  const map = {};
  if (selectedGroups.length) {
    selectedGroups.forEach(group => {
      map[group.groupId] = group.jobIds;
    });
  }
  return map;
}
function JobSelector({
  dateFormatTz,
  singleSelection,
  timeseriesOnly,
  selectedJobIds = [],
  selectedGroups = [],
  selectedJobs = [],
  onSelectionChange
}) {
  const [selectedIds, setSelectedIds] = (0, _react.useState)(mergeSelection(selectedJobIds, selectedGroups, singleSelection));
  const [showAllBarBadges, setShowAllBarBadges] = (0, _react.useState)(false);
  const openJobSelectionFlyout = (0, _use_job_selection_flyout.useJobSelectionFlyout)();

  // Ensure JobSelectionBar gets updated when selection via globalState changes.
  (0, _react.useEffect)(() => {
    setSelectedIds(mergeSelection(selectedJobIds, selectedGroups, singleSelection));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify([selectedJobIds, selectedGroups])]);
  const handleJobSelectionClick = (0, _react.useCallback)(async () => {
    try {
      const result = await openJobSelectionFlyout({
        singleSelection,
        withTimeRangeSelector: true,
        timeseriesOnly,
        selectedIds
      });
      if (result) {
        const {
          newSelection,
          jobIds,
          time
        } = result;
        setSelectedIds(newSelection);
        onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange({
          jobIds,
          time
        });
      }
    } catch {
      // Flyout closed without selection
    }
  }, [onSelectionChange, openJobSelectionFlyout, selectedIds, singleSelection, timeseriesOnly]);
  const page = (0, _react.useMemo)(() => {
    return singleSelection ? _locator.ML_PAGES.SINGLE_METRIC_VIEWER : _locator.ML_PAGES.ANOMALY_EXPLORER;
  }, [singleSelection]);
  const removeJobId = jobOrGroupId => {
    const newSelection = selectedIds.filter(id => !jobOrGroupId.includes(id));
    setSelectedIds(newSelection);
    onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange({
      jobIds: newSelection,
      time: undefined
    });
  };
  const [canGetJobs, canCreateJob] = (0, _check_capabilities.usePermissionCheck)(['canGetJobs', 'canCreateJob']);
  const redirectToADJobManagement = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', 'anomaly_detection');
  function renderJobSelectionBar() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }, selectedIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "xs",
      alignItems: "center",
      "data-test-subj": "mlJobSelectionBadges",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_id_badges.IdBadges, {
      limit: _job_selector_flyout.BADGE_LIMIT,
      onLinkClick: () => setShowAllBarBadges(!showAllBarBadges),
      selectedJobIds: selectedJobIds,
      selectedGroups: selectedGroups,
      selectedJobs: selectedJobs,
      showAllBarBadges: showAllBarBadges,
      page: page,
      onRemoveJobId: removeJobId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 17
      }
    })) : /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.noJobsSelectedLabel",
      defaultMessage: "No jobs selected",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "pencil",
      onClick: handleJobSelectionClick,
      "data-test-subj": "mlButtonEditJobSelection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.ml.jobSelector.jobSelectionButton', {
      defaultMessage: 'Edit job selection'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_feedback_button.FeedBackButton, {
      jobIds: selectedIds,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 13
      }
    })), canGetJobs ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "primary",
      onClick: redirectToADJobManagement,
      disabled: !canGetJobs,
      "data-test-subj": "mlJobSelectorManageJobsButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 15
      }
    }, canCreateJob ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.manageJobsLinkLabel",
      defaultMessage: "Manage jobs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.viewJobsLinkLabel",
      defaultMessage: "View jobs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 19
      }
    }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_job_details_flyout.JobInfoFlyoutsProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }, renderJobSelectionBar(), /*#__PURE__*/_react.default.createElement(_job_details_context_manager.JobInfoFlyoutsManager, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  })));
}