"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAnnotationModal = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/annotations/delete_annotation_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteAnnotationModal = ({
  cancelAction,
  deleteAction,
  isVisible
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, isVisible === true && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.deleteAnnotationModal.deleteAnnotationTitle', {
      defaultMessage: 'Delete this annotation?'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: cancelAction,
    onConfirm: deleteAction,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.deleteAnnotationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.deleteAnnotationModal.deleteButtonLabel', {
      defaultMessage: 'Delete'
    }),
    buttonColor: "danger",
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    className: "eui-textBreakWord",
    "data-test-subj": 'mlAnnotationFlyoutConfirmDeleteModal',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }));
};
exports.DeleteAnnotationModal = DeleteAnnotationModal;
DeleteAnnotationModal.propTypes = {
  cancelAction: _propTypes.default.func.isRequired,
  deleteAction: _propTypes.default.func.isRequired,
  isVisible: _propTypes.default.bool.isRequired
};