"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractDimensions = extractDimensions;
var _constants = require("../../../common/fields/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const INVALID_FIELD_NAME = '_metric_names_hash';
function extractDimensions(fieldCapsMap, fieldNamesFilter) {
  const result = new Map();
  const filterSet = fieldNamesFilter ? new Set(fieldNamesFilter) : undefined;
  for (const [fieldName, fieldInfo] of Object.entries(fieldCapsMap)) {
    if (fieldName === INVALID_FIELD_NAME) {
      continue;
    }
    for (const [type, typeInfo] of Object.entries(fieldInfo)) {
      if (typeInfo.time_series_dimension !== true || filterSet && !filterSet.has(fieldName) || !_constants.DIMENSION_TYPES.includes(type)) {
        continue;
      }
      result.set(fieldName, {
        name: fieldName,
        type: type
      });
    }
  }
  return Array.from(result.values());
}