"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snapshot = void 0;
var _cpu_v = require("./cpu_v2");
var _cpu = require("./cpu");
var _disk_space_usage = require("./disk_space_usage");
var _load = require("./load");
var _log_rate = require("./log_rate");
var _memory = require("./memory");
var _memory_free = require("./memory_free");
var _normalized_load_1m = require("./normalized_load_1m");
var _rx = require("./rx");
var _tx = require("./tx");
var _tx_v = require("./tx_v2");
var _rx_v = require("./rx_v2");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const snapshot = exports.snapshot = {
  cpuV2: _cpu_v.cpuV2,
  diskSpaceUsage: _disk_space_usage.diskSpaceUsage,
  load: _load.load,
  logRate: _log_rate.logRate,
  memory: _memory.memory,
  memoryFree: _memory_free.memoryFree,
  normalizedLoad1m: _normalized_load_1m.normalizedLoad1m,
  rxV2: _rx_v.rxV2,
  txV2: _tx_v.txV2,
  cpu: _cpu.cpu,
  rx: _rx.rx,
  tx: _tx.tx
};