"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.init = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const init = formulas => {
  var _formulas$get$label, _formulas$get$label2, _formulas$get$label3;
  const memoryUsageBreakdown = {
    id: 'memoryUsageBreakdown',
    chartType: 'xy',
    title: _constants.MEMORY_USAGE_LABEL,
    layers: [{
      seriesType: 'area',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [{
        ...formulas.get('memoryCache'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.cache', {
          defaultMessage: 'Cache'
        })
      }, {
        ...formulas.get('memoryUsed'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.used', {
          defaultMessage: 'Used'
        })
      }, {
        ...formulas.get('memoryFreeExcludingCache'),
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.free', {
          defaultMessage: 'Free'
        })
      }]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const memoryUsageXY = {
    id: 'memoryUsage',
    chartType: 'xy',
    title: (_formulas$get$label = formulas.get('memoryUsage').label) !== null && _formulas$get$label !== void 0 ? _formulas$get$label : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('memoryUsage')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_YBOUNDS,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const memoryFree = {
    id: 'memoryFree',
    chartType: 'xy',
    title: (_formulas$get$label2 = formulas.get('memoryFree').label) !== null && _formulas$get$label2 !== void 0 ? _formulas$get$label2 : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('memoryFree')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const memoryUsageMetric = {
    id: 'memoryUsage',
    chartType: 'metric',
    title: (_formulas$get$label3 = formulas.get('memoryUsage').label) !== null && _formulas$get$label3 !== void 0 ? _formulas$get$label3 : '',
    trendLine: true,
    ...formulas.get('memoryUsage')
  };
  return {
    xy: {
      memoryUsageBreakdown,
      memoryUsage: memoryUsageXY,
      memoryFree
    },
    metric: {
      memoryUsage: memoryUsageMetric
    }
  };
};
exports.init = init;