"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initCharts = void 0;
var _cpu = require("./cpu");
var _disk = require("./disk");
var _memory = require("./memory");
var _network = require("./network");
var _logs = require("./logs");
var _metrics = require("../../../kubernetes/node/metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initCharts = formulas => {
  return {
    cpu: (0, _cpu.init)(formulas),
    disk: (0, _disk.init)(formulas),
    memory: (0, _memory.init)(formulas),
    network: (0, _network.init)(formulas),
    logs: _logs.logs,
    ...(formulas.schema === 'ecs' ? {
      kubernetesNode: _metrics.charts.node
    } : {})
  };
};
exports.initCharts = initCharts;