"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metrics = void 0;
var _aws_sqs_messages_visible = require("./tsvb/aws_sqs_messages_visible");
var _aws_sqs_messages_delayed = require("./tsvb/aws_sqs_messages_delayed");
var _aws_sqs_messages_sent = require("./tsvb/aws_sqs_messages_sent");
var _aws_sqs_messages_empty = require("./tsvb/aws_sqs_messages_empty");
var _aws_sqs_oldest_message = require("./tsvb/aws_sqs_oldest_message");
var _metrics_catalog = require("../../shared/metrics/metrics_catalog");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const metrics = exports.metrics = {
  tsvb: {
    awsSQSMessagesVisible: _aws_sqs_messages_visible.awsSQSMessagesVisible,
    awsSQSMessagesDelayed: _aws_sqs_messages_delayed.awsSQSMessagesDelayed,
    awsSQSMessagesSent: _aws_sqs_messages_sent.awsSQSMessagesSent,
    awsSQSMessagesEmpty: _aws_sqs_messages_empty.awsSQSMessagesEmpty,
    awsSQSOldestMessage: _aws_sqs_oldest_message.awsSQSOldestMessage
  },
  requiredTsvb: ['awsSQSMessagesVisible', 'awsSQSMessagesDelayed', 'awsSQSMessagesSent', 'awsSQSMessagesEmpty', 'awsSQSOldestMessage'],
  getAggregations: async args => {
    const {
      snapshot
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./snapshot')));
    const catalog = new _metrics_catalog.MetricsCatalog(snapshot, args === null || args === void 0 ? void 0 : args.schema);
    return catalog;
  },
  getWaffleMapTooltipMetrics: () => ['sqsMessagesVisible', 'sqsMessagesDelayed', 'sqsMessagesEmpty', 'sqsMessagesSent', 'sqsOldestMessage'],
  defaultSnapshot: 'sqsMessagesVisible',
  defaultTimeRangeInSeconds: 14400
};