"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapDetails = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/inspector/map_adapter/map_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETAILS_TAB_ID = 'details';
const STYLE_TAB_ID = 'mapStyle';
const TABS = [{
  id: DETAILS_TAB_ID,
  name: _i18n.i18n.translate('xpack.maps.inspector.mapDetailsTitle', {
    defaultMessage: 'Map details'
  }),
  dataTestSubj: 'mapDetailsTab'
}, {
  id: STYLE_TAB_ID,
  name: _i18n.i18n.translate('xpack.maps.inspector.mapboxStyleTitle', {
    defaultMessage: 'Mapbox style'
  }),
  dataTestSubj: 'mapboxStyleTab'
}];
class MapDetails extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      selectedTabId: DETAILS_TAB_ID
    });
    (0, _defineProperty2.default)(this, "onSelectedTabChanged", id => {
      this.setState({
        selectedTabId: id
      });
    });
    (0, _defineProperty2.default)(this, "renderTab", () => {
      if (STYLE_TAB_ID === this.state.selectedTabId) {
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "mapboxStyleContainer",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          paddingSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 11
          }
        }, JSON.stringify(this.props.style, null, 2)));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
        style: {
          tableLayout: 'auto'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.inspector.centerLonLabel",
        defaultMessage: "Center lon",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        "data-test-subj": "centerLon",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 13
        }
      }, this.props.centerLon)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.inspector.centerLatLabel",
        defaultMessage: "Center lat",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        "data-test-subj": "centerLat",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 13
        }
      }, this.props.centerLat)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.inspector.zoomLabel",
        defaultMessage: "Zoom",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        "data-test-subj": "zoom",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      }, this.props.zoom))));
    });
  }
  renderTabs() {
    return TABS.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => this.onSelectedTabChanged(tab.id),
      isSelected: tab.id === this.state.selectedTabId,
      key: index,
      "data-test-subj": tab.dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, tab.name));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    }, this.renderTabs()), this.renderTab());
  }
}
exports.MapDetails = MapDetails;