"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapContainer = void 0;
var _reactRedux = require("react-redux");
var _map_container = require("./map_container");
var _ui_selectors = require("../../selectors/ui_selectors");
var _actions = require("../../actions");
var _map_selectors = require("../../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    isTimesliderOpen: (0, _ui_selectors.getIsTimesliderOpen)(state),
    isMapLoading: (0, _map_selectors.isMapLoading)(state),
    flyoutDisplay: (0, _ui_selectors.getFlyoutDisplay)(state),
    isFullScreen: (0, _ui_selectors.getIsFullScreen)(state),
    mapInitError: (0, _map_selectors.getMapInitError)(state),
    indexPatternIds: (0, _map_selectors.getQueryableUniqueIndexPatternIds)(state),
    settings: (0, _map_selectors.getMapSettings)(state),
    layerList: (0, _map_selectors.getLayerList)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    exitFullScreen: () => dispatch((0, _actions.exitFullScreen)()),
    cancelAllInFlightRequests: () => dispatch((0, _actions.cancelAllInFlightRequests)())
  };
}
const connected = exports.MapContainer = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_map_container.MapContainer);