"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhereExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _kibana_services = require("../../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/join_editor/resources/where_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class WhereExpression extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onQueryChange", ({
      query
    }) => {
      this.props.onChange(query);
      this._closePopover();
    });
  }
  render() {
    const SearchBar = (0, _kibana_services.getSearchBar)();
    const {
      whereQuery,
      indexPattern
    } = this.props;
    const expressionValue = whereQuery && whereQuery.query ? whereQuery.query : _i18n.i18n.translate('xpack.maps.layerPanel.whereExpression.expressionValuePlaceholder', {
      defaultMessage: '-- add filter --'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "whereClausePopover",
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      ownFocus: true,
      anchorPosition: "leftCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        onClick: this._togglePopover,
        description: _i18n.i18n.translate('xpack.maps.layerPanel.whereExpression.expressionDescription', {
          defaultMessage: 'where'
        }),
        uppercase: false,
        value: expressionValue,
        "data-test-subj": "mapJoinWhereExpressionButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }),
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapFilterEditor",
      "data-test-subj": "mapJoinWhereFilterEditor",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
      className: "mapJoinExpressionHelpText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.whereExpression.helpText",
      defaultMessage: "Use a query to narrow right source.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(SearchBar, {
      appName: _constants.APP_ID,
      showFilterBar: false,
      showDatePicker: false,
      showQueryInput: true,
      query: whereQuery ? whereQuery : (0, _kibana_services.getData)().query.queryString.getDefaultQuery(),
      onQuerySubmit: this._onQueryChange,
      indexPatterns: [indexPattern],
      customSubmitButton: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "mapWhereFilterEditorSubmitButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.whereExpression.queryBarSubmitButtonLabel",
        defaultMessage: "Set filter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 17
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    })));
  }
}
exports.WhereExpression = WhereExpression;