"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESTooltipProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _esQuery = require("@kbn/es-query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/tooltips/es_tooltip_property.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ESTooltipProperty {
  constructor(tooltipProperty, indexPattern, field, applyGlobalQuery) {
    (0, _defineProperty2.default)(this, "_tooltipProperty", void 0);
    (0, _defineProperty2.default)(this, "_indexPattern", void 0);
    (0, _defineProperty2.default)(this, "_field", void 0);
    (0, _defineProperty2.default)(this, "_applyGlobalQuery", void 0);
    this._tooltipProperty = tooltipProperty;
    this._indexPattern = indexPattern;
    this._field = field;
    this._applyGlobalQuery = applyGlobalQuery;
  }
  getPropertyKey() {
    return this._tooltipProperty.getPropertyKey();
  }
  getPropertyName() {
    return this._tooltipProperty.getPropertyName();
  }
  getRawValue() {
    return this._tooltipProperty.getRawValue();
  }
  _getIndexPatternField() {
    return this._indexPattern.fields.getByName(this._field.getRootName());
  }
  getHtmlDisplayValue() {
    if (typeof this.getRawValue() === 'undefined') {
      return '-';
    }
    const indexPatternField = this._getIndexPatternField();
    if (!indexPatternField || !this._field.canValueBeFormatted()) {
      const rawValue = this.getRawValue();
      if (Array.isArray(rawValue)) {
        return _lodash.default.escape(rawValue.join());
      } else {
        return _lodash.default.escape(rawValue);
      }
    }
    const formatter = this._indexPattern.getFormatterForField(indexPatternField);
    const htmlConverter = formatter.getConverterFor('html');
    return htmlConverter ? /*#__PURE__*/_react.default.createElement("span", {
      /*
       * Justification for dangerouslySetInnerHTML:
       * Property value contains value generated by Field formatter
       * Since these formatters produce raw HTML, this component needs to be able to render them as-is, relying
       * on the field formatter to only produce safe HTML.
       */
      dangerouslySetInnerHTML: {
        __html: htmlConverter(this.getRawValue())
      } // eslint-disable-line react/no-danger
      ,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }) : formatter.convert(this.getRawValue());
  }
  isFilterable() {
    if (!this._applyGlobalQuery) {
      return false;
    }
    const indexPatternField = this._getIndexPatternField();
    return !!indexPatternField && (indexPatternField.type === 'string' || indexPatternField.type === 'date' || indexPatternField.type === 'ip' || indexPatternField.type === 'number');
  }
  async getESFilters() {
    if (!this._applyGlobalQuery) {
      return [];
    }
    const indexPatternField = this._getIndexPatternField();
    if (!indexPatternField) {
      return [];
    }
    const rawValue = this.getRawValue();
    if (rawValue == null) {
      const existsFilter = (0, _esQuery.buildExistsFilter)(indexPatternField, this._indexPattern);
      existsFilter.meta.negate = true;
      return [existsFilter];
    } else {
      const values = Array.isArray(rawValue) ? rawValue : [rawValue];
      return values.map(value => {
        return (0, _esQuery.buildPhraseFilter)(indexPatternField, value, this._indexPattern);
      });
    }
  }
}
exports.ESTooltipProperty = ESTooltipProperty;