"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaskLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _mask = require("../../../../layers/vector_layer/mask");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/legend/mask_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MaskLegend extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "_loadAggLabel", async () => {
      const aggLabel = await this.props.esAggField.getLabel();
      if (this._isMounted && aggLabel !== this.state.aggLabel) {
        this.setState({
          aggLabel
        });
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadAggLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidUpdate() {
    this._loadAggLabel();
  }
  _getBucketsName() {
    const source = this.props.esAggField.getSource();
    return 'getBucketsName' in source ? source.getBucketsName() : undefined;
  }
  _getPrefix() {
    if (this.props.onlyShowLabelAndValue) {
      return _i18n.i18n.translate('xpack.maps.maskLegend.is', {
        defaultMessage: '{aggLabel} is',
        values: {
          aggLabel: this.state.aggLabel
        }
      });
    }
    const isJoin = this.props.esAggField.getOrigin() === _constants.FIELD_ORIGIN.JOIN;
    const maskLabel = (0, _mask.getMaskI18nLabel)({
      bucketsName: this._getBucketsName(),
      isJoin
    });
    const maskDescription = (0, _mask.getMaskI18nDescription)({
      aggLabel: this.state.aggLabel,
      isJoin
    });
    return `${maskLabel} ${maskDescription}`;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "left",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, `${this._getPrefix()} `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, (0, _mask.getMaskI18nValue)(this.props.operator, this.props.value))));
  }
}
exports.MaskLegend = MaskLegend;