"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentilesForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _row_action_buttons = require("../row_action_buttons");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/data_mapping/percentiles_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isInvalidPercentile(percentile) {
  if (typeof percentile !== 'number') {
    return true;
  }
  return percentile <= 0 || percentile >= 100;
}
class PercentilesForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onSubmit", () => {
      const hasInvalidPercentile = this.state.percentiles.some(isInvalidPercentile);
      if (!hasInvalidPercentile) {
        this.props.onChange(this.state.percentiles);
      }
    });
    this.state = {
      percentiles: props.initialPercentiles
    };
  }
  render() {
    const rows = this.state.percentiles.map((percentile, index) => {
      const onAdd = () => {
        let newPercentile = '';
        if (typeof percentile === 'number') {
          let delta = 1;
          if (index === this.state.percentiles.length - 1) {
            // Adding row to end of list.
            if (index !== 0) {
              const prevPercentile = this.state.percentiles[index - 1];
              if (typeof prevPercentile === 'number') {
                delta = percentile - prevPercentile;
              }
            }
          } else {
            // Adding row in middle of list.
            const nextPercentile = this.state.percentiles[index + 1];
            if (typeof nextPercentile === 'number') {
              delta = (nextPercentile - percentile) / 2;
            }
          }
          newPercentile = percentile + delta;
          if (newPercentile >= 100) {
            newPercentile = 99;
          }
        }
        const percentiles = [...this.state.percentiles.slice(0, index + 1), newPercentile, ...this.state.percentiles.slice(index + 1)];
        this.setState({
          percentiles
        }, this._onSubmit);
      };
      const onRemove = () => {
        const percentiles = this.state.percentiles.length === 1 ? this.state.percentiles : [...this.state.percentiles.slice(0, index), ...this.state.percentiles.slice(index + 1)];
        this.setState({
          percentiles
        }, this._onSubmit);
      };
      const onPercentileChange = event => {
        const sanitizedValue = parseFloat(event.target.value);
        const percentiles = [...this.state.percentiles];
        percentiles[index] = isNaN(sanitizedValue) ? '' : sanitizedValue;
        this.setState({
          percentiles
        }, this._onSubmit);
      };
      const isInvalid = isInvalidPercentile(percentile);
      const error = isInvalid ? _i18n.i18n.translate('xpack.maps.styles.invalidPercentileMsg', {
        defaultMessage: `Percentile must be a number between 0 and 100, exclusive`
      }) : null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        key: index,
        display: "rowCompressed",
        isInvalid: isInvalid,
        error: error,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        isInvalid: isInvalid,
        value: percentile,
        onChange: onPercentileChange,
        append: /*#__PURE__*/_react.default.createElement(_row_action_buttons.RowActionButtons, {
          onAdd: onAdd,
          onRemove: onRemove,
          showDeleteButton: this.state.percentiles.length > 1,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 15
          }
        }),
        compressed: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }));
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 12
      }
    }, rows);
  }
}
exports.PercentilesForm = PercentilesForm;