"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emsBoundariesLayerWizardConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _vector_layer = require("../../layers/vector_layer");
var _create_source_editor = require("./create_source_editor");
var _ems_file_source = require("./ems_file_source");
var _kibana_services = require("../../../kibana_services");
var _constants = require("../../../../common/constants");
var _ems_boundaries_layer_icon = require("../../layers/wizards/icons/ems_boundaries_layer_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/ems_file_source/ems_boundaries_layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
function getDescription() {
  const emsSettings = (0, _kibana_services.getEMSSettings)();
  return _i18n.i18n.translate('xpack.maps.source.emsFileSourceDescription', {
    defaultMessage: 'Administrative boundaries from {host}',
    values: {
      host: emsSettings.isEMSUrlSet() ? emsSettings.getEMSRoot() : 'Elastic Maps Service'
    }
  });
}
const emsBoundariesLayerWizardConfig = exports.emsBoundariesLayerWizardConfig = {
  id: _constants.WIZARD_ID.EMS_BOUNDARIES,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.REFERENCE],
  checkVisibility: async () => {
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    return emsSettings.isIncludeElasticMapsService();
  },
  description: getDescription(),
  disabledReason: _i18n.i18n.translate('xpack.maps.source.emsFileDisabledReason', {
    defaultMessage: 'Elastic Maps Server requires an Enterprise license'
  }),
  getIsDisabled: () => {
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    return emsSettings.isEMSUrlSet() && !emsSettings.hasOnPremLicense();
  },
  icon: _ems_boundaries_layer_icon.EMSBoundariesLayerIcon,
  renderWizard: ({
    previewLayers,
    mapColors
  }) => {
    const onSourceConfigChange = sourceConfig => {
      const sourceDescriptor = _ems_file_source.EMSFileSource.createDescriptor(sourceConfig);
      const layerDescriptor = _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor
      }, mapColors);
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.EMSFileCreateSourceEditor, {
      onSourceConfigChange: onSourceConfigChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 12
      }
    });
  },
  title: (0, _ems_file_source.getSourceTitle)()
};