"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerTemplate = exports.BOUNDARIES_SOURCE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n_getters = require("../../../../../common/i18n_getters");
var _ems_file_select = require("../../../../components/ems_file_select");
var _geo_index_pattern_select = require("../../../../components/geo_index_pattern_select");
var _single_field_select = require("../../../../components/single_field_select");
var _index_pattern_util = require("../../../../index_pattern_util");
var _util = require("../../../../util");
var _kibana_services = require("../../../../kibana_services");
var _create_choropleth_layer_descriptor = require("./create_choropleth_layer_descriptor");
var _input_strings = require("../../../../connected_components/input_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/choropleth_layer_wizard/layer_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let BOUNDARIES_SOURCE = exports.BOUNDARIES_SOURCE = /*#__PURE__*/function (BOUNDARIES_SOURCE) {
  BOUNDARIES_SOURCE["ELASTICSEARCH"] = "ELASTICSEARCH";
  BOUNDARIES_SOURCE["EMS"] = "EMS";
  return BOUNDARIES_SOURCE;
}({});
const BOUNDARIES_OPTIONS = [{
  id: BOUNDARIES_SOURCE.EMS,
  label: _i18n.i18n.translate('xpack.maps.choropleth.boundaries.ems', {
    defaultMessage: 'Administrative boundaries from the Elastic Maps Service'
  })
}, {
  id: BOUNDARIES_SOURCE.ELASTICSEARCH,
  label: _i18n.i18n.translate('xpack.maps.choropleth.boundaries.elasticsearch', {
    defaultMessage: 'Points, lines, and polygons from Elasticsearch'
  })
}];
class LayerTemplate extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      leftSource: BOUNDARIES_SOURCE.EMS,
      leftEmsFileId: null,
      leftEmsFields: [],
      leftIndexPattern: null,
      leftGeoFields: [],
      leftJoinFields: [],
      leftGeoField: null,
      leftEmsJoinField: null,
      leftElasticsearchJoinField: null,
      rightIndexPatternId: '',
      rightTermsFields: [],
      rightJoinField: null
    });
    (0, _defineProperty2.default)(this, "_loadRightFields", async indexPatternId => {
      this.setState({
        rightTermsFields: []
      });
      let indexPattern;
      try {
        indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
      } catch (err) {
        return;
      }

      // method may be called again before 'get' returns
      // ignore response when fetched index pattern does not match active index pattern
      if (!this._isMounted || indexPatternId !== this.state.rightIndexPatternId) {
        return;
      }
      this.setState({
        rightTermsFields: (0, _index_pattern_util.getTermsFields)(indexPattern.fields)
      });
    });
    (0, _defineProperty2.default)(this, "_loadEmsFileFields", async () => {
      let emsFileLayer;
      try {
        const emsFileLayers = await (0, _util.getEmsFileLayers)();
        emsFileLayer = emsFileLayers.find(fileLayer => {
          return fileLayer.getId() === this.state.leftEmsFileId;
        });
      } catch (error) {
        // ignore error, lack of EMS file layers will be surfaced in EMS file select
      }
      if (!this._isMounted || !emsFileLayer) {
        return;
      }
      const leftEmsFields = emsFileLayer.getFieldsInLanguage().filter(field => {
        return field.type === 'id';
      }).map(field => {
        return {
          value: field.name,
          label: field.description
        };
      });
      this.setState({
        leftEmsFields,
        leftEmsJoinField: leftEmsFields.length ? leftEmsFields[0].value : null
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onLeftSourceChange", optionId => {
      this.setState({
        leftSource: optionId,
        rightJoinField: null
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onLeftIndexPatternChange", indexPattern => {
      this.setState({
        leftIndexPattern: indexPattern,
        leftGeoFields: (0, _index_pattern_util.getGeoFields)(indexPattern.fields),
        leftJoinFields: (0, _index_pattern_util.getSourceFields)(indexPattern.fields),
        leftGeoField: null,
        leftElasticsearchJoinField: null,
        rightJoinField: null
      }, () => {
        // make default geo field selection
        if (this.state.leftGeoFields.length) {
          // @ts-expect-error - avoid wrong "Property 'name' does not exist on type 'never'." compile error
          this._onLeftGeoFieldSelect(this.state.leftGeoFields[0].name);
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onLeftGeoFieldSelect", geoField => {
      if (!geoField) {
        return;
      }
      this.setState({
        leftGeoField: geoField
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onLeftJoinFieldSelect", joinField => {
      if (!joinField) {
        return;
      }
      this.setState({
        leftElasticsearchJoinField: joinField
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onLeftEmsFileChange", emFileId => {
      this.setState({
        leftEmsFileId: emFileId,
        leftEmsJoinField: null,
        rightJoinField: null
      }, () => {
        this._previewLayer();
        this._loadEmsFileFields();
      });
    });
    (0, _defineProperty2.default)(this, "_onLeftEmsFieldChange", selectedOptions => {
      if (selectedOptions.length === 0) {
        return;
      }
      this.setState({
        leftEmsJoinField: selectedOptions[0].value
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onRightIndexPatternChange", indexPatternId => {
      if (!indexPatternId) {
        return;
      }
      this.setState({
        rightIndexPatternId: indexPatternId,
        rightJoinField: null
      }, () => {
        this._previewLayer();
        this._loadRightFields(indexPatternId);
      });
    });
    (0, _defineProperty2.default)(this, "_onRightJoinFieldSelect", joinField => {
      if (!joinField) {
        return;
      }
      this.setState({
        rightJoinField: joinField
      }, this._previewLayer);
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
  }
  _isLeftConfigComplete() {
    if (this.state.leftSource === BOUNDARIES_SOURCE.ELASTICSEARCH) {
      return !!this.state.leftIndexPattern && !!this.state.leftGeoField && !!this.state.leftElasticsearchJoinField;
    } else {
      return !!this.state.leftEmsFileId && !!this.state.leftEmsJoinField;
    }
  }
  _isRightConfigComplete() {
    return !!this.state.rightIndexPatternId && !!this.state.rightJoinField;
  }
  _previewLayer() {
    if (!this._isLeftConfigComplete() || !this._isRightConfigComplete()) {
      this.props.previewLayers([]);
      return;
    }
    const layerDescriptor = this.state.leftSource === BOUNDARIES_SOURCE.ELASTICSEARCH ? (0, _create_choropleth_layer_descriptor.createEsChoroplethLayerDescriptor)({
      // @ts-expect-error - avoid wrong "Property 'id' does not exist on type 'never'." compile error
      leftIndexPatternId: this.state.leftIndexPattern.id,
      leftGeoField: this.state.leftGeoField,
      leftJoinField: this.state.leftElasticsearchJoinField,
      rightIndexPatternId: this.state.rightIndexPatternId,
      rightTermField: this.state.rightJoinField
    }) : (0, _create_choropleth_layer_descriptor.createEmsChoroplethLayerDescriptor)({
      leftEmsFileId: this.state.leftEmsFileId,
      leftEmsField: this.state.leftEmsJoinField,
      rightIndexPatternId: this.state.rightIndexPatternId,
      rightTermField: this.state.rightJoinField
    });
    this.props.previewLayers([layerDescriptor]);
  }
  _renderLeftSourceForm() {
    if (this.state.leftSource === BOUNDARIES_SOURCE.ELASTICSEARCH) {
      let geoFieldSelect;
      if (this.state.leftGeoFields.length) {
        geoFieldSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: _i18n.i18n.translate('xpack.maps.choropleth.geofieldLabel', {
            defaultMessage: 'Geospatial field'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 283,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
          placeholder: _i18n.i18n.translate('xpack.maps.choropleth.geofieldPlaceholder', {
            defaultMessage: 'Select geo field'
          }),
          value: this.state.leftGeoField,
          onChange: this._onLeftGeoFieldSelect,
          fields: this.state.leftGeoFields,
          isClearable: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 288,
            columnNumber: 13
          }
        }));
      }
      let joinFieldSelect;
      if (this.state.leftJoinFields.length) {
        joinFieldSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: _i18n.i18n.translate('xpack.maps.choropleth.joinFieldLabel', {
            defaultMessage: 'Join field'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 303,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
          placeholder: _input_strings.inputStrings.fieldSelectPlaceholder,
          value: this.state.leftElasticsearchJoinField,
          onChange: this._onLeftJoinFieldSelect,
          fields: this.state.leftJoinFields,
          isClearable: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 308,
            columnNumber: 13
          }
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
        dataView: this.state.leftIndexPattern,
        onChange: this._onLeftIndexPatternChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 320,
          columnNumber: 11
        }
      }), geoFieldSelect, joinFieldSelect);
    } else {
      let emsFieldSelect;
      if (this.state.leftEmsFields.length) {
        let selectedOption;
        if (this.state.leftEmsJoinField) {
          selectedOption = this.state.leftEmsFields.find(option => {
            return this.state.leftEmsJoinField === option.value;
          });
        }
        emsFieldSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: _i18n.i18n.translate('xpack.maps.choropleth.joinFieldLabel', {
            defaultMessage: 'Join field'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 340,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
          singleSelection: true,
          isClearable: false,
          options: this.state.leftEmsFields,
          selectedOptions: selectedOption ? [selectedOption] : [],
          onChange: this._onLeftEmsFieldChange,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 345,
            columnNumber: 13
          }
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ems_file_select.EMSFileSelect, {
        value: this.state.leftEmsFileId,
        onChange: this._onLeftEmsFileChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 357,
          columnNumber: 11
        }
      }), emsFieldSelect);
    }
  }
  _renderLeftPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.choropleth.boundariesLabel",
      defaultMessage: "Boundaries source",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 369,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
      name: "boundariesSource",
      options: BOUNDARIES_OPTIONS,
      idSelected: this.state.leftSource,
      onChange: this._onLeftSourceChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 11
      }
    })), this._renderLeftSourceForm());
  }
  _renderRightPanel() {
    if (!this._isLeftConfigComplete()) {
      return null;
    }
    const IndexPatternSelect = (0, _kibana_services.getIndexPatternSelectComponent)();
    let joinFieldSelect;
    if (this.state.rightTermsFields.length) {
      joinFieldSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.maps.choropleth.joinFieldLabel', {
          defaultMessage: 'Join field'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 401,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
        placeholder: _input_strings.inputStrings.fieldSelectPlaceholder,
        value: this.state.rightJoinField,
        onChange: this._onRightJoinFieldSelect,
        fields: this.state.rightTermsFields,
        isClearable: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 406,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 418,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 419,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 420,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.choropleth.statisticsLabel",
      defaultMessage: "Statistics source",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
      placeholder: (0, _i18n_getters.getDataViewSelectPlaceholder)(),
      indexPatternId: this.state.rightIndexPatternId,
      onChange: this._onRightIndexPatternChange,
      isClearable: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 431,
        columnNumber: 11
      }
    })), joinFieldSelect);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this._renderLeftPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 449,
        columnNumber: 9
      }
    }), this._renderRightPanel());
  }
}
exports.LayerTemplate = LayerTemplate;