"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeletePipelineModal = ConfirmDeletePipelineModal;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/logstash/public/application/components/pipeline_editor/confirm_delete_pipeline_modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ConfirmDeletePipelineModal({
  id,
  cancelDeleteModal,
  confirmDeletePipeline
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeletePipelineModal.cancelButtonText",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeletePipelineModal.confirmButtonText",
      defaultMessage: "Delete pipeline",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 9
      }
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CANCEL_BUTTON,
    onCancel: cancelDeleteModal,
    onConfirm: confirmDeletePipeline,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.confirmDeletePipelineModal.deletePipelineTitle",
      defaultMessage: "Delete pipeline {id}",
      values: {
        id
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }),
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, _constants.PIPELINE_EDITOR.DELETE_PIPELINE_MODAL_MESSAGE));
}
ConfirmDeletePipelineModal.propTypes = {
  cancelDeleteModal: _propTypes.default.func.isRequired,
  confirmDeletePipeline: _propTypes.default.func.isRequired,
  id: _propTypes.default.string.isRequired
};