"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.itemToAttributes = itemToAttributes;
exports.savedObjectToItem = savedObjectToItem;
var _references = require("../../../../common/embeddable/transforms/references");
var _get_options = require("../../../../common/embeddable/transforms/get_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function savedObjectToItem(savedObject) {
  var _savedObject$attribut;
  const {
    references,
    attributes,
    ...rest
  } = savedObject;
  const links = (0, _references.injectReferences)((_savedObject$attribut = savedObject.attributes.links) !== null && _savedObject$attribut !== void 0 ? _savedObject$attribut : [], savedObject.references);
  return {
    ...rest,
    attributes: {
      ...attributes,
      links: links.map(link => ({
        ...link,
        ...(link.options && {
          options: (0, _get_options.getOptions)(link.type, link.options)
        })
      }))
    },
    references: (references !== null && references !== void 0 ? references : []).filter(({
      type
    }) => type === 'tag')
  };
}
function itemToAttributes(state) {
  var _state$links;
  const {
    links,
    references
  } = (0, _references.extractReferences)((_state$links = state.links) !== null && _state$links !== void 0 ? _state$links : []);
  return {
    attributes: {
      ...state,
      links
    },
    references
  };
}