"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupSavedObjects = setupSavedObjects;
var _configSchema = require("@kbn/config-schema");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("@kbn/data-views-plugin/common");
var _constants = require("../common/constants");
var _saved_object_migrations = require("./migrations/saved_object_migrations");
var _v = require("./content_management/v0");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extending V0 Lens attributes schema to match existing. Adds loose `version` property.
 */
const lensSOSchemaV1 = _v.lensItemAttributesSchemaV0.extends({
  visState: undefined,
  uiStateJSON: undefined,
  savedSearchRefName: undefined,
  version: _configSchema.schema.maybe(_configSchema.schema.number())
}, {
  unknowns: 'forbid'
});
function setupSavedObjects(core, getFilterMigrations, customVisualizationMigrations) {
  core.savedObjects.registerType({
    name: 'lens',
    indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'multiple-isolated',
    convertToMultiNamespaceTypeVersion: '8.0.0',
    management: {
      icon: 'lensApp',
      defaultSearchField: 'title',
      importableAndExportable: true,
      getTitle: obj => obj.attributes.title,
      getInAppUrl: obj => ({
        path: `/app/lens${(0, _constants.getEditPath)(obj.id)}`,
        uiCapabilitiesPath: 'visualize_v2.show'
      })
    },
    migrations: () => (0, _saved_object_migrations.getAllMigrations)(getFilterMigrations(), _common.DataViewPersistableStateService.getAllMigrations(), customVisualizationMigrations),
    modelVersions: {
      [1]: {
        changes: [{
          // needed to trigger change from dynamic strict to dynamic false
          type: 'mappings_addition',
          addedMappings: {}
        }],
        schemas: {
          forwardCompatibility: lensSOSchemaV1.extendsDeep({
            unknowns: 'ignore'
          }),
          create: lensSOSchemaV1
        }
      }
    },
    mappings: {
      dynamic: false,
      properties: {
        title: {
          type: 'text'
        },
        description: {
          type: 'text'
        },
        visualizationType: {
          type: 'keyword'
        },
        state: {
          dynamic: false,
          properties: {}
        }
      }
    }
  });
  core.savedObjects.registerType({
    name: 'lens-ui-telemetry',
    indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'single',
    mappings: {
      properties: {
        name: {
          type: 'keyword'
        },
        type: {
          type: 'keyword'
        },
        date: {
          type: 'date'
        },
        count: {
          type: 'integer'
        }
      }
    }
  });
}