"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensCreateResponseBodySchema = exports.lensCreateRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _content_management = require("../../../../content_management");
var _v = require("../../../../content_management/v0");
var _utils = require("../../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiConfigData = _content_management.lensAPIConfigSchema.extends({
  id: undefined
});
const v0ConfigData = _v.lensItemSchemaV0.extends({
  id: undefined
});
const lensCreateRequestBodySchema = exports.lensCreateRequestBodySchema = _configSchema.schema.object({
  data: _configSchema.schema.oneOf([apiConfigData, v0ConfigData // Temporarily permit passing old v0 SO attributes on create
  ]),
  // TODO should these options be here or in params?
  options: _configSchema.schema.object({
    ...(0, _utils.pickFromObjectSchema)(_content_management.lensCMCreateOptionsSchema.getPropSchemas(), ['overwrite'])
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});
const lensCreateResponseBodySchema = exports.lensCreateResponseBodySchema = _content_management.lensResponseItemSchema;