"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagcloudVisualization = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expression-xy-plugin/public");
var _common = require("@kbn/expressions-plugin/common");
var _coloring = require("@kbn/coloring");
var _chartIcons = require("@kbn/chart-icons");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _palettes = require("@kbn/palettes");
var _utils = require("../../utils");
var _suggestions = require("./suggestions");
var _tagcloud_toolbar = require("./tagcloud_toolbar");
var _tags_dimension_editor = require("./tags_dimension_editor");
var _constants = require("./constants");
var _color_telemetry_helpers = require("../../lens_ui_telemetry/color_telemetry_helpers");
var _runtime_state = require("./runtime_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/tagcloud/tagcloud_visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TAG_GROUP_ID = 'tags';
const METRIC_GROUP_ID = 'metric';
const getTagcloudVisualization = ({
  paletteService,
  kibanaTheme,
  formatFactory
}) => ({
  id: 'lnsTagcloud',
  getVisualizationTypeId() {
    return this.id;
  },
  visualizationTypes: [{
    id: 'lnsTagcloud',
    icon: _chartIcons.IconChartTagcloud,
    label: _constants.TAGCLOUD_LABEL,
    sortPriority: 12,
    description: _i18n.i18n.translate('xpack.lens.tagcloud.visualizationDescription', {
      defaultMessage: 'Visualize text data frequency or importance.'
    })
  }],
  clearLayer(state) {
    const newState = {
      ...state,
      ..._constants.DEFAULT_STATE
    };
    delete newState.tagAccessor;
    delete newState.valueAccessor;
    delete newState.palette;
    return newState;
  },
  getLayerIds(state) {
    return [state.layerId];
  },
  getDescription() {
    return {
      icon: _chartIcons.IconChartTagcloud,
      label: _constants.TAGCLOUD_LABEL
    };
  },
  getSuggestions: _suggestions.getSuggestions,
  getSuggestionFromConvertToLensContext({
    suggestions,
    context
  }) {
    return !suggestions.length ? undefined : {
      ...suggestions[0],
      visualizationState: {
        ...suggestions[0].visualizationState,
        ...context.configuration
      }
    };
  },
  getMainPalette: state => {
    if (!state) return;
    return state.colorMapping ? {
      type: 'colorMapping',
      value: state.colorMapping
    } : state.palette ? {
      type: 'legacyPalette',
      value: state.palette
    } : undefined;
  },
  triggers: [_public.VIS_EVENT_TO_TRIGGER.filter],
  initialize(addNewLayer, state, mainPalette, datasourceStates) {
    if (state) return (0, _runtime_state.convertToRuntimeState)(state, datasourceStates);
    return {
      layerId: addNewLayer(),
      layerType: _public2.LayerTypes.DATA,
      ..._constants.DEFAULT_STATE,
      colorMapping: (mainPalette === null || mainPalette === void 0 ? void 0 : mainPalette.type) === 'colorMapping' ? mainPalette.value : (0, _utils.getColorMappingDefaults)()
    };
  },
  convertToRuntimeState(state, datasourceStates) {
    return (0, _runtime_state.convertToRuntimeState)(state, datasourceStates);
  },
  getConfiguration({
    state
  }) {
    const canUseColorMapping = state.colorMapping ? true : false;
    let colors = [];
    if (canUseColorMapping) {
      kibanaTheme.theme$.subscribe({
        next(theme) {
          const palettes = (0, _palettes.getKbnPalettes)(theme);
          colors = (0, _coloring.getColorsFromMapping)(palettes, theme.darkMode, state.colorMapping);
        }
      }).unsubscribe();
    } else {
      var _state$palette, _state$palette2;
      colors = paletteService.get(((_state$palette = state.palette) === null || _state$palette === void 0 ? void 0 : _state$palette.name) || 'default').getCategoricalColors(10, (_state$palette2 = state.palette) === null || _state$palette2 === void 0 ? void 0 : _state$palette2.params);
    }
    return {
      groups: [{
        groupId: TAG_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.lens.tagcloud.tagLabel', {
          defaultMessage: 'Tags'
        }),
        layerId: state.layerId,
        accessors: state.tagAccessor ? [{
          columnId: state.tagAccessor,
          triggerIconType: 'colorBy',
          palette: colors
        }] : [],
        supportsMoreColumns: !state.tagAccessor,
        filterOperations: op => op.isBucketed,
        enableDimensionEditor: true,
        required: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsTagcloud_tagDimensionPanel'
      }, {
        groupId: METRIC_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.lens.tagcloud.metricValueLabel', {
          defaultMessage: 'Metric'
        }),
        isMetricDimension: true,
        layerId: state.layerId,
        accessors: state.valueAccessor ? [{
          columnId: state.valueAccessor
        }] : [],
        supportsMoreColumns: !state.valueAccessor,
        filterOperations: op => !op.isBucketed && op.dataType === 'number',
        enableDimensionEditor: true,
        required: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsTagcloud_valueDimensionPanel'
      }]
    };
  },
  getSupportedLayers() {
    return [{
      type: _public2.LayerTypes.DATA,
      label: _i18n.i18n.translate('xpack.lens.tagcloud.addLayer', {
        defaultMessage: 'Add visualization layer'
      })
    }];
  },
  getLayerType(layerId, state) {
    if ((state === null || state === void 0 ? void 0 : state.layerId) === layerId) {
      return _public2.LayerTypes.DATA;
    }
  },
  toExpression: (state, datasourceLayers, attributes, datasourceExpressionsByLayers = {}) => {
    if (!state.tagAccessor || !state.valueAccessor) {
      return null;
    }
    const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
    return {
      type: 'expression',
      chain: [...(datasourceExpression ? datasourceExpression.chain : []), (0, _common.buildExpressionFunction)('tagcloud', {
        bucket: state.tagAccessor,
        metric: state.valueAccessor,
        maxFontSize: state.maxFontSize,
        minFontSize: state.minFontSize,
        orientation: state.orientation,
        palette: (0, _common.buildExpression)([state.palette ? (0, _common.buildExpressionFunction)('theme', {
          variable: 'palette',
          default: [paletteService.get(state.palette.name).toExpression(state.palette.params)]
        }) : (0, _common.buildExpressionFunction)('system_palette', {
          name: 'default'
        })]).toAst(),
        showLabel: state.showLabel,
        colorMapping: state.colorMapping ? JSON.stringify(state.colorMapping) : undefined
      }).toAst()]
    };
  },
  toPreviewExpression: (state, datasourceLayers, datasourceExpressionsByLayers = {}) => {
    if (!state.tagAccessor || !state.valueAccessor) {
      return null;
    }
    const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
    return {
      type: 'expression',
      chain: [...(datasourceExpression ? datasourceExpression.chain : []), (0, _common.buildExpressionFunction)('tagcloud', {
        bucket: state.tagAccessor,
        isPreview: true,
        metric: state.valueAccessor,
        maxFontSize: 18,
        minFontSize: 4,
        orientation: state.orientation,
        palette: (0, _common.buildExpression)([state.palette ? (0, _common.buildExpressionFunction)('theme', {
          variable: 'palette',
          default: [paletteService.get(state.palette.name).toExpression(state.palette.params)]
        }) : (0, _common.buildExpressionFunction)('system_palette', {
          name: 'default'
        })]).toAst(),
        showLabel: false,
        colorMapping: state.colorMapping ? JSON.stringify(state.colorMapping) : undefined
      }).toAst()]
    };
  },
  setDimension({
    columnId,
    groupId,
    prevState
  }) {
    const update = {};
    if (groupId === TAG_GROUP_ID) {
      update.tagAccessor = columnId;
    } else if (groupId === METRIC_GROUP_ID) {
      update.valueAccessor = columnId;
    }
    return {
      ...prevState,
      ...update
    };
  },
  removeDimension({
    prevState,
    layerId,
    columnId
  }) {
    const update = {
      ...prevState
    };
    if (prevState.tagAccessor === columnId) {
      delete update.tagAccessor;
    } else if (prevState.valueAccessor === columnId) {
      delete update.valueAccessor;
    }
    return update;
  },
  DimensionEditorComponent(props) {
    const theme = (0, _useObservable.default)(kibanaTheme.theme$, kibanaTheme.getTheme());
    const palettes = (0, _palettes.getKbnPalettes)(theme);
    if (props.groupId === TAG_GROUP_ID) {
      return /*#__PURE__*/_react.default.createElement(_tags_dimension_editor.TagsDimensionEditor, {
        isDarkMode: theme.darkMode,
        palettes: palettes,
        state: props.state,
        setState: props.setState,
        frame: props.frame,
        panelRef: props.panelRef,
        isInlineEditing: props.isInlineEditing,
        paletteService: paletteService,
        formatFactory: formatFactory,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 311,
          columnNumber: 9
        }
      });
    }
    return null;
  },
  ToolbarComponent(props) {
    return /*#__PURE__*/_react.default.createElement(_tagcloud_toolbar.TagcloudToolbar, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 12
      }
    }));
  },
  getTelemetryEventsOnSave(state, prevState) {
    return (0, _color_telemetry_helpers.getColorMappingTelemetryEvents)(state === null || state === void 0 ? void 0 : state.colorMapping, prevState === null || prevState === void 0 ? void 0 : prevState.colorMapping);
  }
});
exports.getTagcloudVisualization = getTagcloudVisualization;