"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagcloudToolbar = TagcloudToolbar;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/expression-tagcloud-plugin/common");
var _shared_components = require("../../../shared_components");
var _font_size_input = require("./font_size_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/tagcloud/tagcloud_toolbar/tagcloud_toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ORIENTATION_OPTIONS = [{
  value: _common.Orientation.SINGLE,
  text: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientation.single', {
    defaultMessage: 'Single'
  })
}, {
  value: _common.Orientation.RIGHT_ANGLED,
  text: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientation.rightAngled', {
    defaultMessage: 'Right angled'
  })
}, {
  value: _common.Orientation.MULTIPLE,
  text: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientation.multiple', {
    defaultMessage: 'Multiple'
  })
}];
function TagcloudToolbar(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.tagcloud.appearanceLabel', {
      defaultMessage: 'Appearance'
    }),
    type: "visualOptions",
    buttonDataTestSubj: "lnsVisualOptionsButton",
    "data-test-subj": "lnsVisualOptionsPopover",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.fontSizeLabel', {
      defaultMessage: 'Font size'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_font_size_input.FontSizeInput, {
    minFontSize: props.state.minFontSize,
    maxFontSize: props.state.maxFontSize,
    onChange: (minFontSize, maxFontSize) => {
      props.setState({
        ...props.state,
        minFontSize,
        maxFontSize
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientationLabel', {
      defaultMessage: 'Orientation'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: ORIENTATION_OPTIONS,
    value: props.state.orientation,
    onChange: event => {
      props.setState({
        ...props.state,
        orientation: event.target.value
      });
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.showLabel', {
      defaultMessage: 'Show label'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.showLabel', {
      defaultMessage: 'Show label'
    }),
    showLabel: false,
    checked: props.state.showLabel,
    onChange: event => {
      props.setState({
        ...props.state,
        showLabel: event.target.checked
      });
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }))))));
}