"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DimensionDataExtraEditor = DimensionDataExtraEditor;
exports.DimensionEditor = DimensionEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _visualizationUtils = require("@kbn/visualization-utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _palettes = require("@kbn/palettes");
var _collapse_setting = require("../../shared_components/collapse_setting");
var _utils = require("../../../common/expressions/impl/datatable/utils");
var _to_expression = require("./to_expression");
var _color_mapping_by_terms = require("../../shared_components/coloring/color_mapping_by_terms");
var _visualization = require("./visualization");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/partition/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DimensionEditor(props) {
  var _props$frame$activeDa, _getDatatableColumn, _currentLayer$colorsB;
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  const currentLayer = localState.layers.find(layer => layer.layerId === props.layerId);
  const setConfig = (0, _react.useCallback)(({
    color
  }) => {
    if (!currentLayer) {
      return;
    }
    const newColorsByDimension = {
      ...currentLayer.colorsByDimension
    };
    if (color) {
      newColorsByDimension[props.accessor] = color;
    } else {
      delete newColorsByDimension[props.accessor];
    }
    setLocalState({
      ...localState,
      layers: localState.layers.map(layer => layer.layerId === currentLayer.layerId ? {
        ...layer,
        colorsByDimension: newColorsByDimension
      } : layer)
    });
  }, [currentLayer, localState, props.accessor, setLocalState]);
  const setColorMapping = (0, _react.useCallback)(colorMapping => {
    setLocalState({
      ...localState,
      layers: localState.layers.map(layer => layer.layerId === (currentLayer === null || currentLayer === void 0 ? void 0 : currentLayer.layerId) ? {
        ...layer,
        colorMapping
      } : layer)
    });
  }, [localState, currentLayer, setLocalState]);
  if (!currentLayer) {
    return null;
  }
  const originalGroupOrder = (0, _to_expression.getSortedAccessorsForGroup)(props.datasource, currentLayer, 'primaryGroups');
  const firstNonCollapsedColumnId = originalGroupOrder.find(id => !(0, _visualization.isCollapsed)(id, currentLayer));
  const showColorPicker = currentLayer.metrics.includes(props.accessor) && currentLayer.allowMultipleMetrics;
  const colorPickerDisabledMessage = (0, _visualization.hasNonCollapsedSliceBy)(currentLayer) ? ['pie', 'donut'].includes(props.state.shape) ? _i18n.i18n.translate('xpack.lens.pieChart.colorPicker.disabledBecauseSliceBy', {
    defaultMessage: 'You are unable to apply custom colors to individual slices when the layer includes one or more "Slice by" dimensions.'
  }) : _i18n.i18n.translate('xpack.lens.pieChart.colorPicker.disabledBecauseGroupBy', {
    defaultMessage: 'You are unable to apply custom colors to individual slices when the layer includes one or more "Group by" dimensions.'
  }) : undefined;
  const currentData = (_props$frame$activeDa = props.frame.activeData) === null || _props$frame$activeDa === void 0 ? void 0 : _props$frame$activeDa[currentLayer.layerId];
  const columnMeta = (_getDatatableColumn = (0, _utils.getDatatableColumn)(currentData, props.accessor)) === null || _getDatatableColumn === void 0 ? void 0 : _getDatatableColumn.meta;
  const formatter = props.formatFactory(columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.params);
  const categories = (0, _chartExpressionsCommon.getColorCategories)(currentData === null || currentData === void 0 ? void 0 : currentData.rows, props.accessor);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.accessor === firstNonCollapsedColumnId && /*#__PURE__*/_react.default.createElement(_color_mapping_by_terms.ColorMappingByTerms, {
    isDarkMode: props.isDarkMode,
    panelRef: props.panelRef,
    palettes: props.palettes,
    palette: localState.palette,
    setPalette: newPalette => {
      setLocalState({
        ...localState,
        palette: newPalette
      });
    },
    onModeChange: isLegacy => {
      if (isLegacy) setColorMapping();
    },
    colorMapping: currentLayer.colorMapping,
    setColorMapping: setColorMapping,
    categories: categories,
    paletteService: props.paletteService,
    formatter: formatter,
    isInlineEditing: props.isInlineEditing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }), showColorPicker && /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.ColorPicker, (0, _extends2.default)({}, props, {
    swatches: props.palettes.get(_palettes.KbnPalette.Default).colors(10),
    overwriteColor: (_currentLayer$colorsB = currentLayer.colorsByDimension) === null || _currentLayer$colorsB === void 0 ? void 0 : _currentLayer$colorsB[props.accessor],
    defaultColor: (0, _visualization.getDefaultColorForMultiMetricDimension)({
      layer: currentLayer,
      columnId: props.accessor,
      paletteService: props.paletteService,
      datasource: props.datasource,
      palette: localState.palette
    }),
    disabledMessage: colorPickerDisabledMessage,
    setConfig: setConfig,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  })));
}
function DimensionDataExtraEditor(props) {
  var _currentLayer$seconda, _currentLayer$collaps;
  const currentLayer = props.state.layers.find(layer => layer.layerId === props.layerId);
  if (!currentLayer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, [...currentLayer.primaryGroups, ...((_currentLayer$seconda = currentLayer.secondaryGroups) !== null && _currentLayer$seconda !== void 0 ? _currentLayer$seconda : [])].includes(props.accessor) && /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
    value: (currentLayer === null || currentLayer === void 0 ? void 0 : (_currentLayer$collaps = currentLayer.collapseFns) === null || _currentLayer$collaps === void 0 ? void 0 : _currentLayer$collaps[props.accessor]) || '',
    onChange: collapseFn => {
      props.setState({
        ...props.state,
        layers: props.state.layers.map(layer => layer.layerId !== props.layerId ? layer : {
          ...layer,
          collapseFns: {
            ...layer.collapseFns,
            [props.accessor]: collapseFn
          }
        })
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }));
}