"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorMode = getColorMode;
exports.getDefaultConfigForMode = getDefaultConfigForMode;
exports.getSecondaryDynamicTrendBaselineValue = getSecondaryDynamicTrendBaselineValue;
exports.getSecondaryLabelSelected = getSecondaryLabelSelected;
exports.getTrendPalette = getTrendPalette;
exports.isSecondaryTrendConfigInvalid = isSecondaryTrendConfigInvalid;
var _i18n = require("@kbn/i18n");
var _palettes = require("@kbn/palettes");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColorMode(secondaryTrend, isMetricNumeric) {
  if (!secondaryTrend || secondaryTrend.type === 'none') {
    return 'none';
  }
  if (!isMetricNumeric || secondaryTrend.type === 'static') {
    return 'static';
  }
  return 'dynamic';
}
function getSecondaryLabelSelected(state, {
  defaultSecondaryLabel,
  colorMode,
  isPrimaryMetricNumeric
}) {
  var _state$secondaryTrend, _state$secondaryLabel;
  const isAutoSecondaryLabel = state.secondaryLabel === undefined;
  const hasSecondaryLabelOverride = isAutoSecondaryLabel &&
  // use colorMode as gatekeeper to avoid checking the secondaryTrend as dynamic when
  // it is not enabled due to other conflicts (i.e. primary metric is not numeric)
  colorMode === 'dynamic' && ((_state$secondaryTrend = state.secondaryTrend) === null || _state$secondaryTrend === void 0 ? void 0 : _state$secondaryTrend.type) === 'dynamic' && state.secondaryTrend.baselineValue === 'primary' && isPrimaryMetricNumeric;
  if (isAutoSecondaryLabel) {
    return hasSecondaryLabelOverride ? {
      mode: 'custom',
      label: _i18n.i18n.translate('xpack.lens.metric.prefixText.labelTrendOverride', {
        defaultMessage: 'Difference'
      })
    } : {
      mode: 'auto'
    };
  }
  if (state.secondaryLabel === '') {
    return {
      mode: 'none'
    };
  }
  return {
    mode: 'custom',
    label: (_state$secondaryLabel = state.secondaryLabel) !== null && _state$secondaryLabel !== void 0 ? _state$secondaryLabel : defaultSecondaryLabel
  };
}
function getDefaultConfigForMode(mode) {
  if (mode === 'none') {
    return {
      type: 'none'
    };
  }
  if (mode === 'static') {
    return {
      type: 'static',
      color: _constants.SECONDARY_DEFAULT_STATIC_COLOR
    };
  }
  return {
    type: 'dynamic',
    visuals: 'both',
    paletteId: _palettes.KbnPalette.CompareTo,
    reversed: false,
    baselineValue: 0
  };
}
function getTrendPalette(colorMode, secondaryTrend, theme) {
  if (colorMode !== 'dynamic') {
    return undefined;
  }
  if (!secondaryTrend || secondaryTrend.type !== colorMode) {
    const defaultConfig = getDefaultConfigForMode(colorMode);
    const palette = (0, _palettes.getKbnPalettes)(theme).get(defaultConfig.paletteId);
    const colors = palette === null || palette === void 0 ? void 0 : palette.colors(3);
    return defaultConfig.reversed ? colors.reverse() : colors;
  }
  const palette = (0, _palettes.getKbnPalettes)(theme).get(secondaryTrend.paletteId);
  const colors = palette === null || palette === void 0 ? void 0 : palette.colors(3);
  return secondaryTrend.reversed ? colors.reverse() : colors;
}
function getSecondaryDynamicTrendBaselineValue(isPrimaryMetricNumeric, baselineValue) {
  // If primary is not numeric, reset baseline value to 0
  if (!isPrimaryMetricNumeric && baselineValue === 'primary') return 0;
  return baselineValue;
}
function isSecondaryTrendConfigInvalid(secondaryTrend, colorMode, isPrimaryMetricNumeric) {
  return colorMode !== (secondaryTrend === null || secondaryTrend === void 0 ? void 0 : secondaryTrend.type) || (secondaryTrend === null || secondaryTrend === void 0 ? void 0 : secondaryTrend.type) === 'dynamic' && (secondaryTrend === null || secondaryTrend === void 0 ? void 0 : secondaryTrend.baselineValue) === 'primary' && !isPrimaryMetricNumeric;
}