"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePicker = PalettePicker;
var _react = _interopRequireDefault(require("react"));
var _coloring = require("@kbn/coloring");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _palettes = require("@kbn/palettes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/palette_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PalettePicker({
  palettes,
  activePalette,
  setPalette
}) {
  const paletteName = (0, _coloring.getActivePaletteName)(activePalette === null || activePalette === void 0 ? void 0 : activePalette.name);
  const palettesToShow = palettes.getAll().filter(({
    internal
  }) => !internal).map(({
    id,
    title,
    tag,
    getCategoricalColors
  }) => {
    return {
      value: id,
      title,
      append: (0, _palettes.getAppendedTag)(tag),
      type: 'fixed',
      palette: getCategoricalColors(10, id === paletteName ? activePalette === null || activePalette === void 0 ? void 0 : activePalette.params : undefined)
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.palettePicker.label', {
      defaultMessage: 'Palette'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    fullWidth: true,
    "data-test-subj": "lns-palettePicker",
    palettes: palettesToShow,
    onChange: newPalette => {
      setPalette({
        type: 'palette',
        name: newPalette
      });
    },
    valueOfSelected: paletteName,
    selectionDisplay: 'palette',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
}