"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionWrapper = ExpressionWrapper;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _error_helper = require("../editor_frame_service/error_helper");
var _expression_renderer_styles = require("../expression_renderer_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/react_embeddable/expression_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ExpressionWrapper({
  ExpressionRenderer: ExpressionRendererComponent,
  expression,
  searchContext,
  variables,
  handleEvent,
  interactive,
  searchSessionId,
  onData$,
  onRender$,
  renderMode,
  syncColors,
  syncTooltips,
  syncCursor,
  hasCompatibleActions,
  getCompatibleCellValueActions,
  style,
  className,
  onRuntimeError,
  addUserMessages,
  executionContext,
  lensInspector,
  noPadding,
  abortController
}) {
  if (!expression) return null;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('lnsExpressionRenderer', 'eui-scrollBar', className),
    css: _expression_renderer_styles.lnsExpressionRendererStyle,
    style: style,
    "data-test-subj": "lens-embeddable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, {
    padding: noPadding ? undefined : 's',
    variables: variables,
    allowCache: true,
    expression: expression,
    interactive: interactive,
    searchContext: searchContext,
    searchSessionId: searchSessionId
    // @ts-expect-error upgrade typescript v4.9.5
    ,
    onData$: onData$,
    onRender$: onRender$,
    inspectorAdapters: lensInspector.getInspectorAdapters(),
    renderMode: renderMode,
    syncColors: syncColors,
    syncTooltips: syncTooltips,
    syncCursor: syncCursor,
    executionContext: executionContext,
    abortController: abortController,
    renderError: (errorMessage, error) => {
      const messages = (0, _error_helper.getOriginalRequestErrorMessages)(error || null);
      addUserMessages(messages);
      onRuntimeError((error === null || error === void 0 ? void 0 : error.original) || new Error(errorMessage ? errorMessage : ''));
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null); // the embeddable will take care of displaying the messages
    },
    onEvent: handleEvent,
    hasCompatibleActions: hasCompatibleActions,
    getCompatibleCellValueActions: getCompatibleCellValueActions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
}