"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _advanced_editor = require("./advanced_editor");
var _constants = require("./constants");
var _shared_components = require("../../../../../shared_components");
var _help_popover = require("../../../help_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/ranges/range_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GranularityHelpPopover = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopover, {
    anchorPosition: "upCenter",
    button: /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopoverButton, {
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.ranges.granularityHelpText', {
      defaultMessage: 'How it works'
    })),
    closePopover: () => setIsPopoverOpen(false),
    isOpen: isPopoverOpen,
    title: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.granularityPopoverTitle', {
      defaultMessage: 'How granularity interval works'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.ranges.granularityPopoverBasicExplanation', {
    defaultMessage: 'Interval granularity divides the field into evenly spaced intervals based on the minimum and maximum values for the field.'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.ranges.granularityPopoverExplanation",
    defaultMessage: "The size of the interval is a \"nice\" value. When the granularity of the slider changes, the interval stays the same when the \u201Cnice\u201D interval is the same. The minimum granularity is 1, and the maximum value is {setting}. To change the maximum granularity, go to Advanced settings.",
    values: {
      setting: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 22
        }
      }, _public.UI_SETTINGS.HISTOGRAM_MAX_BARS)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.ranges.granularityPopoverAdvancedExplanation', {
    defaultMessage: 'Intervals are incremented by 10, 5 or 2. For example, an interval can be 100 or 0.2 .'
  })));
};
const BaseRangeEditor = ({
  maxBars,
  step,
  maxHistogramBars,
  onToggleEditor,
  onMaxBarsChange,
  includeEmptyRows,
  onChangeIncludeEmptyRows
}) => {
  const [maxBarsValue, setMaxBarsValue] = (0, _react.useState)(String(maxBars));
  (0, _shared_components.useDebounceWithOptions)(() => {
    onMaxBarsChange(Number(maxBarsValue));
  }, {
    skipFirstRender: true
  }, _constants.TYPING_DEBOUNCE_TIME, [maxBarsValue]);
  const granularityLabel = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.granularity', {
    defaultMessage: 'Intervals granularity'
  });
  const decreaseButtonLabel = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.decreaseButtonLabel', {
    defaultMessage: 'Decrease granularity'
  });
  const increaseButtonLabel = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.increaseButtonLabel', {
    defaultMessage: 'Increase granularity'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    hasChildLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.ranges.includeEmptyRows', {
      defaultMessage: 'Include empty rows'
    })),
    checked: Boolean(includeEmptyRows),
    onChange: () => {
      onChangeIncludeEmptyRows(!includeEmptyRows);
    },
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: granularityLabel,
    "data-test-subj": "indexPattern-ranges-section-label",
    labelType: "legend",
    fullWidth: true,
    display: "rowCompressed",
    labelAppend: /*#__PURE__*/_react.default.createElement(GranularityHelpPopover, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 22
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: decreaseButtonLabel,
    delay: "long",
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "minusInCircle",
    color: "text",
    "data-test-subj": "lns-indexPattern-range-maxBars-minus",
    onClick: () => setMaxBarsValue('' + Math.max(Number(maxBarsValue) - step, _constants.MIN_HISTOGRAM_BARS)),
    "aria-label": decreaseButtonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    fullWidth: true,
    "aria-label": granularityLabel,
    "data-test-subj": "lns-indexPattern-range-maxBars-field",
    min: _constants.MIN_HISTOGRAM_BARS,
    max: maxHistogramBars,
    step: step,
    value: maxBarsValue,
    onChange: ({
      currentTarget
    }) => setMaxBarsValue(currentTarget.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: increaseButtonLabel,
    delay: "long",
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "plusInCircle",
    color: "text",
    "data-test-subj": "lns-indexPattern-range-maxBars-plus",
    onClick: () => setMaxBarsValue('' + Math.min(Number(maxBarsValue) + step, maxHistogramBars)),
    "aria-label": increaseButtonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "controlsHorizontal",
    onClick: () => onToggleEditor(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.ranges.customIntervalsToggle', {
    defaultMessage: 'Create custom ranges'
  })));
};
const RangeEditor = ({
  setParam,
  params,
  maxHistogramBars,
  maxBars,
  granularityStep,
  onChangeMode,
  rangeFormatter
}) => {
  const [isAdvancedEditor, toggleAdvancedEditor] = (0, _react.useState)(params.type === _constants.MODES.Range);
  if (isAdvancedEditor) {
    return /*#__PURE__*/_react.default.createElement(_advanced_editor.AdvancedRangeEditor, {
      ranges: params.ranges,
      setRanges: ranges => {
        setParam('ranges', ranges);
      },
      onToggleEditor: () => {
        onChangeMode(_constants.MODES.Histogram);
        toggleAdvancedEditor(false);
      },
      formatter: rangeFormatter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(BaseRangeEditor, {
    includeEmptyRows: params.includeEmptyRows,
    maxBars: maxBars,
    step: granularityStep,
    maxHistogramBars: maxHistogramBars,
    onMaxBarsChange: newMaxBars => {
      setParam('maxBars', newMaxBars);
    },
    onChangeIncludeEmptyRows: includeEmptyRows => {
      setParam('includeEmptyRows', includeEmptyRows);
    },
    onToggleEditor: () => {
      onChangeMode(_constants.MODES.Range);
      toggleAdvancedEditor(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 5
    }
  });
};
exports.RangeEditor = RangeEditor;