"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WrappingHelpPopover = exports.HelpPopoverButton = exports.HelpPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/help_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HelpPopoverButton = ({
  children,
  onClick
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "question",
    css: helpPopoverStyles.button(euiThemeContext),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }), children));
};
exports.HelpPopoverButton = HelpPopoverButton;
const HelpPopoverContent = ({
  title,
  children
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 17
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-yScroll",
    size: "s",
    css: helpPopoverStyles.content(euiThemeContext),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, children));
};
const helpPopoverStyles = {
  button: ({
    euiTheme
  }) => (0, _react2.css)`
    margin-right: ${euiTheme.size.xs};
  `,
  content: ({
    euiTheme
  }) => (0, _react2.css)`
    max-height: 40vh;
    padding: ${euiTheme.size.m};
  `
};
const HelpPopover = ({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    button: button,
    closePopover: closePopover,
    isOpen: isOpen,
    ownFocus: true,
    panelStyle: {
      maxInlineSize: '480px'
    },
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(HelpPopoverContent, {
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, children));
};
exports.HelpPopover = HelpPopover;
const WrappingHelpPopover = ({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title,
  startServices
}) => {
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    anchorPosition: anchorPosition,
    button: button,
    closePopover: closePopover,
    isOpen: isOpen,
    ownFocus: true,
    panelStyle: {
      maxInlineSize: '480px'
    },
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(HelpPopoverContent, {
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, children)));
};
exports.WrappingHelpPopover = WrappingHelpPopover;