"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _operations = require("../operations");
var _field_select = require("./field_select");
var _pure_utils = require("../pure_utils");
var _shared_components = require("../operations/definitions/shared_components");
var _shared_styles = require("./shared_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/reference_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const operationDisplay = (0, _operations.getOperationDisplay)();
const getFunctionOptions = (operationSupportMatrix, operationDefinitionMap, column) => {
  return Array.from(operationSupportMatrix.operationTypes).map(operationType => {
    var _operationSupportMatr;
    const def = operationDefinitionMap[operationType];
    const label = operationDisplay[operationType].displayName;
    const isCompatible = !column || column && (0, _pure_utils.hasField)(column) && def.input === 'field' && ((_operationSupportMatr = operationSupportMatrix.fieldByOperation.get(operationType)) === null || _operationSupportMatr === void 0 ? void 0 : _operationSupportMatr.has(column.sourceField)) || column && !(0, _pure_utils.hasField)(column) && def.input !== 'field';
    return {
      label,
      value: operationType,
      css: _shared_styles.operationsButtonStyles,
      'data-test-subj': `lns-indexPatternDimension-${operationType}${isCompatible ? '' : ' incompatible'}`
    };
  });
};
const ReferenceEditor = props => {
  var _incompleteColumn$sou;
  const {
    currentIndexPattern,
    validation,
    selectionStyle,
    labelAppend,
    column,
    incompleteColumn,
    functionLabel,
    onChooseField,
    onDeleteColumn,
    onResetIncomplete,
    onChooseFunction,
    fieldLabel,
    operationDefinitionMap,
    isInline
  } = props;
  const selectedOperationDefinition = column && operationDefinitionMap[column.operationType];

  // Basically the operation support matrix, but different validation
  const operationSupportMatrix = (0, _react.useMemo)(() => {
    const operationTypes = new Set();
    const operationWithoutField = new Set();
    const operationByField = new Map();
    const fieldByOperation = new Map();
    Object.values(operationDefinitionMap).filter(({
      hidden,
      allowAsReference
    }) => !hidden && allowAsReference).sort((op1, op2) => {
      return op1.displayName.localeCompare(op2.displayName);
    }).forEach(op => {
      if (op.input === 'field') {
        const allFields = currentIndexPattern.fields.filter(field => (0, _operations.isOperationAllowedAsReference)({
          operationType: op.type,
          validation,
          field,
          indexPattern: currentIndexPattern
        }));
        if (allFields.length) {
          operationTypes.add(op.type);
          fieldByOperation.set(op.type, new Set(allFields.map(({
            name
          }) => name)));
          allFields.forEach(field => {
            var _operationByField$get;
            const fieldOps = (_operationByField$get = operationByField.get(field.name)) !== null && _operationByField$get !== void 0 ? _operationByField$get : new Set();
            fieldOps.add(op.type);
            operationByField.set(field.name, fieldOps);
          });
        }
      } else if ((0, _operations.isOperationAllowedAsReference)({
        operationType: op.type,
        validation,
        indexPattern: currentIndexPattern
      })) {
        operationTypes.add(op.type);
        operationWithoutField.add(op.type);
      }
    });
    return {
      operationTypes,
      operationWithoutField,
      operationByField,
      fieldByOperation
    };
  }, [currentIndexPattern, validation, operationDefinitionMap]);
  if (selectionStyle === 'hidden') {
    return null;
  }
  const incompleteOperation = incompleteColumn === null || incompleteColumn === void 0 ? void 0 : incompleteColumn.operationType;
  const incompleteField = (_incompleteColumn$sou = incompleteColumn === null || incompleteColumn === void 0 ? void 0 : incompleteColumn.sourceField) !== null && _incompleteColumn$sou !== void 0 ? _incompleteColumn$sou : null;
  const functionOptions = getFunctionOptions(operationSupportMatrix, operationDefinitionMap, column);
  const selectedOption = incompleteOperation ? [functionOptions === null || functionOptions === void 0 ? void 0 : functionOptions.find(({
    value
  }) => value === incompleteOperation)] : column ? [functionOptions === null || functionOptions === void 0 ? void 0 : functionOptions.find(({
    value
  }) => value === column.operationType)] : [];

  // what about a field changing type and becoming invalid?
  // Let's say this change makes the indexpattern without any number field but the operation was set to a numeric operation.
  // At this point the ComboBox will crash.
  // Therefore check if the selectedOption is in functionOptions and in case fill it in as disabled option
  const showSelectionFunctionInvalid = Boolean(selectedOption.length && selectedOption[0] == null);
  if (showSelectionFunctionInvalid) {
    const selectedOperationType = incompleteOperation || (column === null || column === void 0 ? void 0 : column.operationType);
    const brokenFunctionOption = {
      label: selectedOperationType && operationDisplay[selectedOperationType].displayName,
      value: selectedOperationType,
      css: _shared_styles.operationsButtonStyles,
      'data-test-subj': `lns-indexPatternDimension-${selectedOperationType} incompatible`
    };
    functionOptions === null || functionOptions === void 0 ? void 0 : functionOptions.push(brokenFunctionOption);
    selectedOption[0] = brokenFunctionOption;
  }

  // If the operationType is incomplete, the user needs to select a field- so
  // the function is marked as valid.
  const showOperationInvalid = !column && !Boolean(incompleteOperation);
  // The field is invalid if the operation has been updated without a field,
  // or if we are in a field-only mode but empty state
  const showFieldInvalid = Boolean(incompleteOperation) || selectionStyle === 'field' && !column;
  // Check if the field still exists to protect from changes
  const showFieldMissingInvalid = !currentIndexPattern.getFieldByName(incompleteField !== null && incompleteField !== void 0 ? incompleteField : column === null || column === void 0 ? void 0 : column.sourceField);
  const ParamEditor = selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.paramEditor;
  const functionPlaceholder = functionLabel || _i18n.i18n.translate('xpack.lens.indexPattern.referenceFunctionPlaceholder', {
    defaultMessage: 'Sub-function'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, selectionStyle !== 'field' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.FormRow, {
    isInline: isInline,
    "data-test-subj": "indexPattern-subFunction-selection-row",
    label: functionLabel || _i18n.i18n.translate('xpack.lens.indexPattern.chooseSubFunction', {
      defaultMessage: 'Choose a sub-function'
    }),
    fullWidth: true,
    isInvalid: showOperationInvalid || showSelectionFunctionInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: false,
    "data-test-subj": "indexPattern-reference-function",
    placeholder: functionPlaceholder,
    options: functionOptions,
    isInvalid: showOperationInvalid || showSelectionFunctionInvalid,
    selectedOptions: selectedOption,
    singleSelection: {
      asPlainText: true
    },
    "aria-label": functionPlaceholder,
    onChange: choices => {
      if (choices.length === 0) {
        return onDeleteColumn();
      }
      const operationType = choices[0].value;
      // When it has an incomplete state, make sure to clear it up before updating
      if (incompleteColumn) {
        onResetIncomplete();
      }
      if ((column === null || column === void 0 ? void 0 : column.operationType) === operationType) {
        return;
      }
      const possibleFieldNames = operationSupportMatrix.fieldByOperation.get(operationType);
      const field = column && 'sourceField' in column && possibleFieldNames !== null && possibleFieldNames !== void 0 && possibleFieldNames.has(column.sourceField) ? currentIndexPattern.getFieldByName(column.sourceField) : (possibleFieldNames === null || possibleFieldNames === void 0 ? void 0 : possibleFieldNames.size) === 1 // @ts-expect-error upgrade typescript v5.9.3
      ? currentIndexPattern.getFieldByName(possibleFieldNames.values().next().value) : undefined;
      onChooseFunction(operationType, field);
      return;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  })) : null, !column || (selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.input) === 'field' ? /*#__PURE__*/_react.default.createElement(_shared_components.FormRow, {
    isInline: isInline,
    "data-test-subj": "indexPattern-reference-field-selection-row",
    label: fieldLabel || _i18n.i18n.translate('xpack.lens.indexPattern.chooseField', {
      defaultMessage: 'Field'
    }),
    fullWidth: true,
    isInvalid: showFieldInvalid || showFieldMissingInvalid,
    labelAppend: labelAppend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    fieldIsInvalid: showFieldInvalid || showFieldMissingInvalid,
    currentIndexPattern: currentIndexPattern,
    operationByField: operationSupportMatrix.operationByField,
    selectedOperationType:
    // Allows operation to be selected before creating a valid column
    column ? column.operationType : incompleteOperation,
    selectedField: // Allows field to be selected
    incompleteField !== null && incompleteField !== void 0 ? incompleteField : column === null || column === void 0 ? void 0 : column.sourceField,
    incompleteOperation: incompleteOperation,
    markAllFieldsCompatible: selectionStyle === 'field',
    onDeleteColumn: onDeleteColumn,
    onChoose: onChooseField,
    showTimeSeriesDimensions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 11
    }
  })) : null, column && !incompleteColumn && ParamEditor && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(ParamEditor, (0, _extends2.default)({}, props, {
    isReferenced: true,
    operationDefinitionMap: operationDefinitionMap,
    currentColumn: column,
    indexPattern: props.currentIndexPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 11
    }
  }))));
};
exports.ReferenceEditor = ReferenceEditor;