"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnMetaFn = getColumnMetaFn;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getColumnMetaFn(datasourceStates) {
  var _datasourceStates$for, _datasourceStates$tex;
  if (datasourceStates !== null && datasourceStates !== void 0 && (_datasourceStates$for = datasourceStates.formBased) !== null && _datasourceStates$for !== void 0 && _datasourceStates$for.layers) {
    const layers = datasourceStates.formBased.layers;
    return (layerId, columnId) => {
      var _layers$layerId, _layers$layerId$colum, _column$params, _column$params$parent;
      const column = (_layers$layerId = layers[layerId]) === null || _layers$layerId === void 0 ? void 0 : (_layers$layerId$colum = _layers$layerId.columns) === null || _layers$layerId$colum === void 0 ? void 0 : _layers$layerId$colum[columnId];
      return {
        fieldType: column && 'params' in column ? (_column$params = column.params) === null || _column$params === void 0 ? void 0 : (_column$params$parent = _column$params.parentFormat) === null || _column$params$parent === void 0 ? void 0 : _column$params$parent.id : undefined,
        dataType: column === null || column === void 0 ? void 0 : column.dataType
      };
    };
  }
  if (datasourceStates !== null && datasourceStates !== void 0 && (_datasourceStates$tex = datasourceStates.textBased) !== null && _datasourceStates$tex !== void 0 && _datasourceStates$tex.layers) {
    const layers = datasourceStates.textBased.layers;
    return (layerId, columnId) => {
      var _layers$layerId2, _layers$layerId2$colu, _column$meta;
      const column = (_layers$layerId2 = layers[layerId]) === null || _layers$layerId2 === void 0 ? void 0 : (_layers$layerId2$colu = _layers$layerId2.columns) === null || _layers$layerId2$colu === void 0 ? void 0 : _layers$layerId2$colu.find(c => c.columnId === columnId);
      return {
        dataType: column === null || column === void 0 ? void 0 : (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.type
      };
    };
  }
  return null;
}