"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceUrlHashQuery = replaceUrlHashQuery;
exports.replaceUrlQuery = replaceUrlQuery;
var _queryString = require("query-string");
var _url = require("url");
var _parse = require("./parse");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function replaceUrlQuery(rawUrl, queryReplacer) {
  const url = (0, _parse.parseUrl)(rawUrl);
  // @ts-expect-error `queryReplacer` expects key/value pairs with values of type `string | string[] | null`,
  // however `@types/node` says that `url.query` has values of type `string | string[] | undefined`.
  // After investigating this, it seems that no matter what the values will be of type `string | string[]`
  const newQuery = queryReplacer(url.query || {});
  const searchQueryString = (0, _queryString.stringify)(_.url.encodeQuery(newQuery), {
    sort: false,
    encode: false
  });
  if (!url.search && !searchQueryString) return rawUrl; // nothing to change. return original url
  return (0, _url.format)({
    ...url,
    search: searchQueryString
  });
}
function replaceUrlHashQuery(rawUrl, queryReplacer) {
  const url = (0, _parse.parseUrl)(rawUrl);
  const hash = (0, _parse.parseUrlHash)(rawUrl);
  // @ts-expect-error `queryReplacer` expects key/value pairs with values of type `string | string[] | null`,
  // however `@types/node` says that `url.query` has values of type `string | string[] | undefined`.
  // After investigating this, it seems that no matter what the values will be of type `string | string[]`
  const newQuery = queryReplacer((hash === null || hash === void 0 ? void 0 : hash.query) || {});
  const searchQueryString = (0, _queryString.stringify)(_.url.encodeQuery(newQuery), {
    sort: false,
    encode: false
  });
  if ((!hash || !hash.search) && !searchQueryString) return rawUrl; // nothing to change. return original url
  return (0, _url.format)({
    ...url,
    hash: (0, _url.format)({
      pathname: (hash === null || hash === void 0 ? void 0 : hash.pathname) || '',
      search: searchQueryString
    })
  });
}