"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewPageActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/kibana_react/public/overview_page/overview_page_actions/overview_page_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const overviewPageActions = ({
  addDataHref,
  application,
  devToolsHref,
  hidden,
  managementHref,
  showDevToolsLink,
  showManagementLink
}) => {
  const {
    management: isManagementEnabled,
    dev_tools: isDevToolsEnabled
  } = application.capabilities.navLinks;
  const actionAddData = /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "homeAddData",
    className: "kbnOverviewPageHeader__actionButton",
    flush: "both",
    href: addDataHref,
    iconType: "plusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('kibana-react.kbnOverviewPageHeader.addIntegrationsButtonLabel', {
    defaultMessage: 'Add integrations'
  })));
  const actionStackManagement = managementHref && showManagementLink && isManagementEnabled ? /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "homeManage",
    className: "kbnOverviewPageHeader__actionButton",
    flush: "both",
    iconType: "gear",
    href: managementHref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('kibana-react.kbnOverviewPageHeader.stackManagementButtonLabel', {
    defaultMessage: 'Manage'
  }))) : null;
  const actionDevTools = devToolsHref && showDevToolsLink && isDevToolsEnabled ? /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "homeDevTools",
    className: "kbnOverviewPageHeader__actionButton",
    flush: "both",
    iconType: "wrench",
    href: devToolsHref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('kibana-react.kbnOverviewPageHeader.devToolsButtonLabel', {
    defaultMessage: 'Dev tools'
  }))) : null;
  const actions = [actionAddData, actionStackManagement, actionDevTools];
  return !hidden ? actions.filter(obj => obj) : [];
};
exports.overviewPageActions = overviewPageActions;